/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.ui.documenttemplates;

import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.qubdocs.domain.DocumentTemplate;
import org.fenixedu.qubdocs.domain.DocumentTemplateFile;
import org.fenixedu.qubdocs.domain.serviceRequests.AcademicServiceRequestTemplate;
import org.fenixedu.qubdocs.dto.documenttemplates.AcademicServiceRequestTemplateBean;
import org.fenixedu.qubdocs.ui.FenixeduQubdocsReportsBaseController;
import org.fenixedu.qubdocs.ui.FenixeduQubdocsReportsController;
import org.fenixedu.qubdocs.ui.documenttemplates.AcademicServiceRequestTemplateController$callable$createAcademicServiceRequestTemplate;
import org.fenixedu.qubdocs.ui.documenttemplates.AcademicServiceRequestTemplateController$callable$createAcademicServiceRequestTemplate$1;
import org.fenixedu.qubdocs.ui.documenttemplates.AcademicServiceRequestTemplateController$callable$deleteAcademicServiceRequestTemplate;
import org.fenixedu.qubdocs.ui.documenttemplates.AcademicServiceRequestTemplateController$callable$updateAcademicServiceRequestTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=FenixeduQubdocsReportsController.class, title="label.title.documentTemplates", accessGroup="logged")
@RequestMapping(value={"/qubdocsreports/documenttemplates/academicservicerequesttemplate"})
public class AcademicServiceRequestTemplateController
extends FenixeduQubdocsReportsBaseController {
    public static final String QUB_INCLUDE_PREFIX = "qub-";
    public static final String CONTROLLER_URL = "/qubdocsreports/documenttemplates/academicservicerequesttemplate";
    private static final String _SEARCHTEMPLATES_URI = "/searchtemplates";
    public static final String SEARCHTEMPLATES_URL = "/qubdocsreports/documenttemplates/academicservicerequesttemplate/searchtemplates";
    private static final String _SEARCHTEMPLATES_TO_VIEW_ACTION_URI = "/searchtemplates/view/";
    public static final String SEARCHTEMPLATES_TO_VIEW_ACTION_URL = "/qubdocsreports/documenttemplates/academicservicerequesttemplate/searchtemplates/view/";
    private static final String _SEARCHTEMPLATES_TO_CREATECUSTOMTEMPLATE_URI = "/searchtemplates/createcustomtemplate";
    public static final String SEARCHTEMPLATES_TO_CREATECUSTOMTEMPLATE_URL = "/qubdocsreports/documenttemplates/academicservicerequesttemplate/searchtemplates/createcustomtemplate";
    private static final String _CREATESTANDARDTEMPLATE_URI = "/createstandardtemplate";
    public static final String CREATESTANDARDTEMPLATE_URL = "/qubdocsreports/documenttemplates/academicservicerequesttemplate/createstandardtemplate";
    private static final String _CREATESTANDARDTEMPLATEPOSTBACK_URI = "/createstandardtemplatepostback";
    public static final String CREATESTANDARDTEMPLATEPOSTBACK_URL = "/qubdocsreports/documenttemplates/academicservicerequesttemplate/createstandardtemplatepostback";
    private static final String _CREATECUSTOMTEMPLATE_URI = "/createcustomtemplate";
    public static final String CREATECUSTOMTEMPLATE_URL = "/qubdocsreports/documenttemplates/academicservicerequesttemplate/createcustomtemplate";
    private static final String _READTEMPLATE_URI = "/readtemplate/";
    public static final String READTEMPLATE_URL = "/qubdocsreports/documenttemplates/academicservicerequesttemplate/readtemplate/";
    private static final String _DELETETEMPLATE_URI = "/deletetemplate/";
    public static final String DELETETEMPLATE_URL = "/qubdocsreports/documenttemplates/academicservicerequesttemplate/deletetemplate/";
    private static final String _UPDATETEMPLATE_URI = "/updatetemplate/";
    public static final String UPDATETEMPLATE_URL = "/qubdocsreports/documenttemplates/academicservicerequesttemplate/updatetemplate/";
    public static final Advice advice$deleteAcademicServiceRequestTemplate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicServiceRequestTemplate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicServiceRequestTemplate$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateAcademicServiceRequestTemplate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/qubdocsreports/documenttemplates/academicservicerequesttemplate/searchtemplates";
    }

    private AcademicServiceRequestTemplateBean getAcademicServiceRequestTemplateBean(Model model) {
        return (AcademicServiceRequestTemplateBean)model.asMap().get("academicServiceRequestTemplateBean");
    }

    private void setAcademicServiceRequestTemplateBean(AcademicServiceRequestTemplateBean bean, Model model) {
        model.addAttribute("academicServiceRequestTemplateBeanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("academicServiceRequestTemplateBean", (Object)bean);
    }

    private AcademicServiceRequestTemplate getAcademicServiceRequestTemplate(Model model) {
        return (AcademicServiceRequestTemplate)((Object)model.asMap().get("academicServiceRequestTemplate"));
    }

    private void setAcademicServiceRequestTemplate(AcademicServiceRequestTemplate academicServiceRequestTemplate, Model model) {
        model.addAttribute("academicServiceRequestTemplate", (Object)academicServiceRequestTemplate);
    }

    public void deleteAcademicServiceRequestTemplate(AcademicServiceRequestTemplate academicServiceRequestTemplate) {
        Object object = advice$deleteAcademicServiceRequestTemplate.perform((Callable)new AcademicServiceRequestTemplateController$callable$deleteAcademicServiceRequestTemplate(this, academicServiceRequestTemplate));
    }

    static /* synthetic */ void advised$deleteAcademicServiceRequestTemplate(AcademicServiceRequestTemplateController this_, AcademicServiceRequestTemplate academicServiceRequestTemplate) {
        academicServiceRequestTemplate.delete();
    }

    @RequestMapping(value={"/searchtemplates"})
    public String searchTemplates(@RequestParam(value="active", required=false) Boolean active, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="servicerequesttype", required=false) ServiceRequestType serviceRequestType, @RequestParam(value="custom", required=false) Boolean custom, Model model) {
        if (active == null) {
            active = Boolean.TRUE;
        }
        List<AcademicServiceRequestTemplate> searchtemplatesResultsDataSet = this.filterSearchTemplates(active, name, serviceRequestType, custom);
        if (serviceRequestType != null) {
            model.addAttribute("selectedServiceRequestType", (Object)serviceRequestType);
        }
        model.addAttribute("searchtemplatesResultsDataSet", searchtemplatesResultsDataSet);
        model.addAttribute("AcademicServiceRequestTemplate_serviceRequestType_options", ServiceRequestType.findActive().sorted(Comparator.comparing(ServiceRequestType_Base::getName)).collect(Collectors.toList()));
        return "qubdocsreports/documenttemplates/academicservicerequesttemplate/searchtemplates";
    }

    private Stream<AcademicServiceRequestTemplate> getSearchUniverseSearchTemplatesDataSet() {
        return AcademicServiceRequestTemplate.findAll();
    }

    private List<AcademicServiceRequestTemplate> filterSearchTemplates(Boolean active, LocalizedString name, ServiceRequestType serviceRequestType, Boolean custom) {
        return this.getSearchUniverseSearchTemplatesDataSet().filter(academicServiceRequestTemplate -> active == null || active.equals(academicServiceRequestTemplate.getActive())).filter(academicServiceRequestTemplate -> name == null || name.isEmpty() || name.getLocales().stream().allMatch(locale -> academicServiceRequestTemplate.getName().getContent(locale) != null && academicServiceRequestTemplate.getName().getContent(locale).toLowerCase().contains(name.getContent(locale).toLowerCase()))).filter(academicServiceRequestTemplate -> serviceRequestType == null || serviceRequestType == academicServiceRequestTemplate.getServiceRequestType()).filter(academicServiceRequestTemplate -> custom == null || custom.equals(academicServiceRequestTemplate.getCustom())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/searchtemplates/view/{oid}"})
    public String processSearchTemplatesToViewAction(@PathVariable(value="oid") AcademicServiceRequestTemplate academicServiceRequestTemplate, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READTEMPLATE_URL + academicServiceRequestTemplate.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/searchtemplates/createcustomtemplate"})
    public String processSearchtemplatesCreateCustomTemplate(Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(CREATECUSTOMTEMPLATE_URL, model, redirectAttributes);
    }

    @RequestMapping(value={"/createstandardtemplate"}, method={RequestMethod.GET})
    public String createstandardtemplate(Model model) {
        model.addAttribute("AcademicServiceRequestTemplate_language_options", (Object)CoreConfiguration.supportedLocales());
        model.addAttribute("AcademicServiceRequestTemplate_serviceRequestType_options", ServiceRequestType.findActive().sorted(Comparator.comparing(ServiceRequestType_Base::getName)).collect(Collectors.toList()));
        model.addAttribute("AcademicServiceRequestTemplate_degreeType_options", DegreeType.all().collect(Collectors.toList()));
        model.addAttribute("AcademicServiceRequestTemplate_degree_options", new ArrayList());
        model.addAttribute("AcademicServiceRequestTemplate_programConclusion_options", new ArrayList());
        AcademicServiceRequestTemplateBean bean = new AcademicServiceRequestTemplateBean();
        bean.setLanguageDataSource(new ArrayList<Locale>(CoreConfiguration.supportedLocales()));
        bean.setServiceRequestTypeDataSource(ServiceRequestType.findActive().sorted(Comparator.comparing(ServiceRequestType_Base::getName)).collect(Collectors.toList()));
        bean.setDegreeTypeDataSource(DegreeType.all().sorted().collect(Collectors.toList()));
        this.setAcademicServiceRequestTemplateBean(bean, model);
        return "qubdocsreports/documenttemplates/academicservicerequesttemplate/angularcreatestandardtemplate";
    }

    @RequestMapping(value={"/createstandardtemplatepostback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createstandardtemplatepostback(@RequestParam(value="bean", required=false) AcademicServiceRequestTemplateBean bean, Model model) {
        DegreeType degreeType = bean.getDegreeType();
        if (degreeType != null) {
            bean.setDegreeDataSource(new ArrayList<Degree>(degreeType.getDegreeSet()));
            bean.setProgramConclusionDataSource(new ArrayList<ProgramConclusion>(Bennu.getInstance().getProgramConclusionSet()));
        }
        this.setAcademicServiceRequestTemplateBean(bean, model);
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/createstandardtemplate"}, method={RequestMethod.POST})
    public String createstandardtemplate(@RequestParam(value="bean", required=false) AcademicServiceRequestTemplateBean bean, @RequestParam(value="documentTemplateFile", required=true) MultipartFile documentTemplateFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            AcademicServiceRequestTemplate academicServiceRequestTemplate = this.createAcademicServiceRequestTemplate(bean.getName(), bean.getDescription(), bean.getLanguage(), bean.getServiceRequestType(), bean.getDegreeType(), bean.getDegree(), bean.getProgramConclusion(), documentTemplateFile);
            model.addAttribute("academicServiceRequestTemplate", (Object)academicServiceRequestTemplate);
            return this.redirect(READTEMPLATE_URL + this.getAcademicServiceRequestTemplate(model).getExternalId(), model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
            this.setAcademicServiceRequestTemplateBean(bean, model);
            return "qubdocsreports/documenttemplates/academicservicerequesttemplate/angularcreatestandardtemplate";
        }
    }

    public AcademicServiceRequestTemplate createAcademicServiceRequestTemplate(LocalizedString localizedString, LocalizedString localizedString2, Locale locale, ServiceRequestType serviceRequestType, DegreeType degreeType, Degree degree, ProgramConclusion programConclusion, MultipartFile multipartFile) throws IOException {
        return (AcademicServiceRequestTemplate)((Object)advice$createAcademicServiceRequestTemplate.perform((Callable)new AcademicServiceRequestTemplateController$callable$createAcademicServiceRequestTemplate(this, localizedString, localizedString2, locale, serviceRequestType, degreeType, degree, programConclusion, multipartFile)));
    }

    static /* synthetic */ AcademicServiceRequestTemplate advised$createAcademicServiceRequestTemplate(AcademicServiceRequestTemplateController this_, LocalizedString name, LocalizedString description, Locale language, ServiceRequestType serviceRequestType, DegreeType degreeType, Degree degree, ProgramConclusion programConclusion, MultipartFile documentTemplateFile) throws IOException {
        AcademicServiceRequestTemplate academicServiceRequestTemplate = AcademicServiceRequestTemplate.create(name, description, language, serviceRequestType, degreeType, programConclusion, degree);
        DocumentTemplateFile.create((DocumentTemplate)((Object)academicServiceRequestTemplate), documentTemplateFile.getOriginalFilename(), documentTemplateFile.getBytes());
        return academicServiceRequestTemplate;
    }

    @RequestMapping(value={"/createcustomtemplate"}, method={RequestMethod.GET})
    public String createcustomtemplate(Model model) {
        model.addAttribute("AcademicServiceRequestTemplate_language_options", (Object)CoreConfiguration.supportedLocales());
        model.addAttribute("AcademicServiceRequestTemplate_serviceRequestType_options", ServiceRequestType.findActive().sorted(Comparator.comparing(ServiceRequestType_Base::getName)).collect(Collectors.toList()));
        return "qubdocsreports/documenttemplates/academicservicerequesttemplate/createcustomtemplate";
    }

    @RequestMapping(value={"/createcustomtemplate"}, method={RequestMethod.POST})
    public String createcustomtemplate(@RequestParam(value="name", required=true) LocalizedString name, @RequestParam(value="description", required=true) LocalizedString description, @RequestParam(value="language", required=true) Locale language, @RequestParam(value="servicerequesttype", required=true) ServiceRequestType serviceRequestType, @RequestParam(value="documentTemplateFile", required=true) MultipartFile documentTemplateFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            AcademicServiceRequestTemplate academicServiceRequestTemplate = this.createAcademicServiceRequestTemplate(name, description, language, serviceRequestType, documentTemplateFile);
            model.addAttribute("academicServiceRequestTemplate", (Object)academicServiceRequestTemplate);
            return this.redirect(READTEMPLATE_URL + this.getAcademicServiceRequestTemplate(model).getExternalId(), model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
            return this.createcustomtemplate(model);
        }
    }

    public AcademicServiceRequestTemplate createAcademicServiceRequestTemplate(LocalizedString localizedString, LocalizedString localizedString2, Locale locale, ServiceRequestType serviceRequestType, MultipartFile multipartFile) throws IOException {
        return (AcademicServiceRequestTemplate)((Object)advice$createAcademicServiceRequestTemplate$1.perform((Callable)new AcademicServiceRequestTemplateController$callable$createAcademicServiceRequestTemplate$1(this, localizedString, localizedString2, locale, serviceRequestType, multipartFile)));
    }

    static /* synthetic */ AcademicServiceRequestTemplate advised$createAcademicServiceRequestTemplate(AcademicServiceRequestTemplateController this_, LocalizedString name, LocalizedString description, Locale language, ServiceRequestType serviceRequestType, MultipartFile documentTemplateFile) throws IOException {
        AcademicServiceRequestTemplate academicServiceRequestTemplate = AcademicServiceRequestTemplate.createCustom(name, description, language, serviceRequestType);
        DocumentTemplateFile.create((DocumentTemplate)((Object)academicServiceRequestTemplate), documentTemplateFile.getOriginalFilename(), documentTemplateFile.getBytes());
        return academicServiceRequestTemplate;
    }

    @RequestMapping(value={"/readtemplate/{oid}"})
    public String readtemplate(@PathVariable(value="oid") AcademicServiceRequestTemplate academicServiceRequestTemplate, Model model) {
        this.setAcademicServiceRequestTemplate(academicServiceRequestTemplate, model);
        return "qubdocsreports/documenttemplates/academicservicerequesttemplate/readtemplate";
    }

    @RequestMapping(value={"/deletetemplate/{oid}"}, method={RequestMethod.POST})
    public String deletetemplate(@PathVariable(value="oid") AcademicServiceRequestTemplate academicServiceRequestTemplate, Model model, RedirectAttributes redirectAttributes) {
        this.setAcademicServiceRequestTemplate(academicServiceRequestTemplate, model);
        try {
            String templateName = academicServiceRequestTemplate.getName().getContent();
            XDocReportRegistry.getRegistry().unregisterReport(academicServiceRequestTemplate.getExternalId());
            this.deleteAcademicServiceRequestTemplate(academicServiceRequestTemplate);
            this.addInfoMessage(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)"label.info.documentTemplates.successfulDelete", (String[])new String[]{templateName}), model);
            return this.redirect(SEARCHTEMPLATES_URL, model, redirectAttributes);
        }
        catch (Throwable ex) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            return this.redirect(READTEMPLATE_URL + academicServiceRequestTemplate.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/updatetemplate/{oid}"}, method={RequestMethod.GET})
    public String updatetemplate(@PathVariable(value="oid") AcademicServiceRequestTemplate academicServiceRequestTemplate, Model model) {
        this.setAcademicServiceRequestTemplate(academicServiceRequestTemplate, model);
        return "qubdocsreports/documenttemplates/academicservicerequesttemplate/updatetemplate";
    }

    @RequestMapping(value={"/updatetemplate/{oid}"}, method={RequestMethod.POST})
    public String updatetemplate(@PathVariable(value="oid") AcademicServiceRequestTemplate academicServiceRequestTemplate, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="description", required=false) LocalizedString description, @RequestParam(value="active", required=false) Boolean active, @RequestParam(value="documentTemplateFile", required=false) MultipartFile documentTemplateFile, Model model, RedirectAttributes redirectAttributes) {
        this.setAcademicServiceRequestTemplate(academicServiceRequestTemplate, model);
        try {
            XDocReportRegistry.getRegistry().unregisterReport(academicServiceRequestTemplate.getExternalId());
            this.updateAcademicServiceRequestTemplate(name, description, active, documentTemplateFile, model);
            this.addInfoMessage(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)"label.info.documentTemplates.successfulUpdate", (String[])new String[]{name.getContent()}), model);
            return this.redirect(UPDATETEMPLATE_URL + this.getAcademicServiceRequestTemplate(model).getExternalId(), model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
            return this.updatetemplate(academicServiceRequestTemplate, model);
        }
    }

    public void updateAcademicServiceRequestTemplate(LocalizedString localizedString, LocalizedString localizedString2, Boolean bl, MultipartFile multipartFile, Model model) throws IOException {
        Object object = advice$updateAcademicServiceRequestTemplate.perform((Callable)new AcademicServiceRequestTemplateController$callable$updateAcademicServiceRequestTemplate(this, localizedString, localizedString2, bl, multipartFile, model));
    }

    static /* synthetic */ void advised$updateAcademicServiceRequestTemplate(AcademicServiceRequestTemplateController this_, LocalizedString name, LocalizedString description, Boolean active, MultipartFile documentTemplateFile, Model model) throws IOException {
        this_.getAcademicServiceRequestTemplate(model).setName(name);
        this_.getAcademicServiceRequestTemplate(model).setDescription(description);
        this_.getAcademicServiceRequestTemplate(model).setActive(active);
        if (!documentTemplateFile.isEmpty()) {
            DocumentTemplateFile oldFile = this_.getAcademicServiceRequestTemplate(model).getDocumentTemplateFile();
            oldFile.delete();
            DocumentTemplateFile.create((DocumentTemplate)((Object)this_.getAcademicServiceRequestTemplate(model)), documentTemplateFile.getOriginalFilename(), documentTemplateFile.getBytes());
        }
    }

    @RequestMapping(value={"/search/download/{documentTemplateFileId}"}, method={RequestMethod.GET})
    public void processSearchToDownloadAction(@PathVariable(value="documentTemplateFileId") DocumentTemplateFile documentTemplateFile, HttpServletResponse response) {
        try {
            response.setContentType(documentTemplateFile.getContentType());
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)documentTemplateFile.getFilename()).replaceAll("\\s", "_"), "UTF-8");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(documentTemplateFile.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

