/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.service.process;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.curriculum.CurriculumModuleServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.ulisboa.integration.sas.domain.SocialServicesConfiguration;
import org.fenixedu.ulisboa.integration.sas.dto.AbstractScholarshipStudentBean;
import org.fenixedu.ulisboa.integration.sas.dto.ScholarshipStudentOtherYearBean;
import org.fenixedu.ulisboa.integration.sas.service.process.AbstractFillScholarshipService;
import org.joda.time.YearMonthDay;

public class FillScholarshipServiceOtherYearService
extends AbstractFillScholarshipService {
    @Override
    protected void fillSpecificInfo(AbstractScholarshipStudentBean inputBean, Registration registration, ExecutionYear requestYear) {
        ScholarshipStudentOtherYearBean bean = (ScholarshipStudentOtherYearBean)inputBean;
        bean.setNumberOfDegreeChanges(this.getNumberOfDegreeChanges(registration));
        bean.setHasMadeDegreeChangeOnCurrentYear(this.hasMadeDegreeChange(registration, requestYear));
        bean.setCycleNumberOfEnrolmentsYearsInIntegralRegime(this.getCycleNumberOfEnrolmentYearsInIntegralRegime(registration, requestYear));
        bean.setNumberOfApprovedEcts(registration.getCurriculum(requestYear).getSumEctsCredits());
        ExecutionYear lastEnrolmentYear = this.getCycleLastEnrolmentYear(registration, requestYear);
        Registration lastRegistration = this.getLastEnrolmentYearRegistration(registration, lastEnrolmentYear);
        if (lastEnrolmentYear != null && lastRegistration != null) {
            bean.setNumberOfEnrolledEctsLastYear(this.getEnroledCredits(lastRegistration, lastEnrolmentYear));
            bean.setNumberOfApprovedEctsLastYear(this.getApprovedCredits(lastRegistration, lastEnrolmentYear));
            bean.setLastEnrolmentYear(lastEnrolmentYear.getBeginDateYearMonthDay().getYear());
            bean.setLastEnrolmentCurricularYear(lastRegistration.getCurriculum(lastEnrolmentYear).getCurricularYear());
            StudentCurricularPlan lastRegistrationCurricularPlan = RegistrationServices.getStudentCurricularPlan((Registration)lastRegistration, (ExecutionYear)lastEnrolmentYear);
            YearMonthDay lastAcademicActDate = CurriculumModuleServices.calculateLastAcademicActDate((CurriculumGroup)lastRegistrationCurricularPlan.getRoot(), (ExecutionYear)lastEnrolmentYear, (boolean)false);
            bean.setLastAcademicActDateLastYear(lastAcademicActDate != null ? lastAcademicActDate.toLocalDate() : lastEnrolmentYear.getEndLocalDate());
        }
    }

    private Integer getNumberOfDegreeChanges(Registration currentRegistration) {
        return (int)FillScholarshipServiceOtherYearService.getCycleRegistrations(currentRegistration).stream().filter(r -> SocialServicesConfiguration.getInstance().getIngressionTypeWhichAreDegreeTransferSet().contains(r.getIngressionType())).count();
    }

    private Boolean hasMadeDegreeChange(Registration registration, ExecutionYear requestYear) {
        return registration.getStartExecutionYear() == requestYear && SocialServicesConfiguration.getInstance().getIngressionTypeWhichAreDegreeTransferSet().contains(registration.getIngressionType());
    }

    private ExecutionYear getCycleLastEnrolmentYear(Registration registration, ExecutionYear requestYear) {
        return FillScholarshipServiceOtherYearService.getCycleEnrolmentYears(registration, requestYear.getPreviousExecutionYear()).stream().sorted(ExecutionYear.COMPARATOR_BY_BEGIN_DATE.reversed()).findFirst().orElse(null);
    }

    private Registration getLastEnrolmentYearRegistration(Registration registration, ExecutionYear lastEnrolmentYear) {
        if (lastEnrolmentYear == null) {
            return null;
        }
        return FillScholarshipServiceOtherYearService.getCycleRegistrations(registration).stream().filter(r -> RegistrationServices.getEnrolmentYears((Registration)r).contains(lastEnrolmentYear)).sorted(Registration.COMPARATOR_BY_START_DATE.reversed()).findFirst().orElse(null);
    }

    private Integer getCycleNumberOfEnrolmentYearsInIntegralRegime(Registration registration, ExecutionYear requestYear) {
        return (int)FillScholarshipServiceOtherYearService.getCycleEnrolmentYears(registration, requestYear).stream().filter(ey -> !registration.isPartialRegime(ey)).count();
    }
}

