/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.service.sicabe;

import com.google.common.base.Objects;
import com.qubit.solution.fenixedu.bennu.webservices.services.client.BennuWebServiceClient;
import com.sun.xml.ws.fault.ServerSOAPFaultException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.BindingProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.datacontract.schemas._2004._07.sicabe.Titularidade;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilderForXLSX;
import org.fenixedu.ulisboa.integration.sas.domain.CandidacyState;
import org.fenixedu.ulisboa.integration.sas.domain.SasScholarshipCandidacy;
import org.fenixedu.ulisboa.integration.sas.domain.SasScholarshipCandidacyState;
import org.fenixedu.ulisboa.integration.sas.domain.SasScholarshipData;
import org.fenixedu.ulisboa.integration.sas.domain.SasScholarshipDataChangeLog;
import org.fenixedu.ulisboa.integration.sas.domain.SasScholarshipDataChangeLog_Base;
import org.fenixedu.ulisboa.integration.sas.dto.AbstractScholarshipStudentBean;
import org.fenixedu.ulisboa.integration.sas.dto.ScholarshipStudentFirstYearBean;
import org.fenixedu.ulisboa.integration.sas.dto.ScholarshipStudentOtherYearBean;
import org.fenixedu.ulisboa.integration.sas.service.process.AbstractFillScholarshipService;
import org.fenixedu.ulisboa.integration.sas.service.process.FillScholarshipException;
import org.fenixedu.ulisboa.integration.sas.service.process.FillScholarshipFirstYearService;
import org.fenixedu.ulisboa.integration.sas.service.process.FillScholarshipServiceOtherYearService;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService$callable$createLogEntry;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService$callable$init;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService$callable$loadAllSasScholarshipCandidacies;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService$callable$processAllSasScholarshipCandidacies;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService$callable$processSasScholarshipCandidacies;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService$callable$removeAllCandidaciesWithoutRegistrationAndLoadAllSasCandidacies;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService$callable$removeAllSasScholarshipsCandidacies;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService$callable$removeSasScholarshipsCandidacy;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService$callable$sendCandidacyToSicabe;
import org.fenixedu.ulisboa.integration.sas.util.SasPTUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.dges.schemas.data.sicabe.v1.AlterarCursoInsituicaoRequest;
import pt.dges.schemas.data.sicabe.v1.AlterarDadosAcademicosPrimeiraVezRequest;
import pt.dges.schemas.data.sicabe.v1.AlterarDadosAcademicosRestantesCasosRequest;
import pt.dges.schemas.data.sicabe.v1.CandidaturaSubmetida;
import pt.dges.schemas.data.sicabe.v1.IdentificadorCandidatura;
import pt.dges.schemas.data.sicabe.v1.ObjectFactory;
import pt.dges.schemas.data.sicabe.v1.ObterCandidaturasSubmetidasRequest;
import pt.dges.schemas.data.sicabe.v1.ObterCandidaturasSubmetidasResponse;
import pt.dges.schemas.data.sicabe.v1.ObterEstadoCandidaturaRequest;
import pt.dges.schemas.data.sicabe.v1.RegistarMatriculaAlunoRequest;
import pt.dges.schemas.data.sicabe.v1.ResultadoEstadoCandidatura;
import pt.dges.schemas.data.sicabe.v1.TipoDocumentoIdentificacao;
import pt.dges.schemas.data.sicabe.v1.TipoRegime;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicos;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosAlterarDadosAcademicosPrimeiraVezSicabeBusinessMessageFaultFaultMessage;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosAlterarDadosAcademicosPrimeiraVezSicabeErrorMessageFaultFaultMessage;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosAlterarDadosAcademicosPrimeiraVezSicabeValidationMessageFaultFaultMessage;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosAlterarDadosAcademicosRestantesCasosSicabeBusinessMessageFaultFaultMessage;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosAlterarDadosAcademicosRestantesCasosSicabeErrorMessageFaultFaultMessage;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosAlterarDadosAcademicosRestantesCasosSicabeValidationMessageFaultFaultMessage;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosObterCandidaturasSubmetidasSicabeBusinessMessageFaultFaultMessage;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosObterCandidaturasSubmetidasSicabeErrorMessageFaultFaultMessage;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosObterCandidaturasSubmetidasSicabeValidationMessageFaultFaultMessage;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicos_Service;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SicabeExternalService
extends BennuWebServiceClient<DadosAcademicos> {
    public static final Advice advice$init = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeAllCandidaciesWithoutRegistrationAndLoadAllSasCandidacies = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$loadAllSasScholarshipCandidacies = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$processAllSasScholarshipCandidacies = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$processSasScholarshipCandidacies = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$sendCandidacyToSicabe = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeAllSasScholarshipsCandidacies = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeSasScholarshipsCandidacy = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createLogEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void init() {
        Object object = advice$init.perform((Callable)new SicabeExternalService$callable$init());
    }

    static /* synthetic */ void advised$init() {
        new SicabeExternalService();
    }

    protected BindingProvider getService() {
        return (BindingProvider)new DadosAcademicos_Service().getCustomBindingDadosAcademicos();
    }

    public void removeAllCandidaciesWithoutRegistrationAndLoadAllSasCandidacies(ExecutionYear executionYear) throws ServerSOAPFaultException, DadosAcademicosObterCandidaturasSubmetidasSicabeBusinessMessageFaultFaultMessage, DadosAcademicosObterCandidaturasSubmetidasSicabeErrorMessageFaultFaultMessage, DadosAcademicosObterCandidaturasSubmetidasSicabeValidationMessageFaultFaultMessage {
        Object object = advice$removeAllCandidaciesWithoutRegistrationAndLoadAllSasCandidacies.perform((Callable)new SicabeExternalService$callable$removeAllCandidaciesWithoutRegistrationAndLoadAllSasCandidacies(this, executionYear));
    }

    static /* synthetic */ void advised$removeAllCandidaciesWithoutRegistrationAndLoadAllSasCandidacies(SicabeExternalService this_, ExecutionYear executionYear) throws ServerSOAPFaultException, DadosAcademicosObterCandidaturasSubmetidasSicabeBusinessMessageFaultFaultMessage, DadosAcademicosObterCandidaturasSubmetidasSicabeErrorMessageFaultFaultMessage, DadosAcademicosObterCandidaturasSubmetidasSicabeValidationMessageFaultFaultMessage {
        this_.removeAllCandidaciesWithoutRegistration(executionYear);
        this_.loadAllSasScholarshipCandidacies(executionYear);
    }

    private void removeAllCandidaciesWithoutRegistration(ExecutionYear executionYear) {
        SasScholarshipCandidacy.findAll().stream().filter(c -> c.getExecutionYear() == executionYear && c.getRegistration() == null).forEach(c -> this.removeSasScholarshipsCandidacy((SasScholarshipCandidacy)((Object)c)));
    }

    private void loadAllSasScholarshipCandidacies(ExecutionYear executionYear) throws DadosAcademicosObterCandidaturasSubmetidasSicabeBusinessMessageFaultFaultMessage, DadosAcademicosObterCandidaturasSubmetidasSicabeErrorMessageFaultFaultMessage, DadosAcademicosObterCandidaturasSubmetidasSicabeValidationMessageFaultFaultMessage, ServerSOAPFaultException {
        Object object = advice$loadAllSasScholarshipCandidacies.perform((Callable)new SicabeExternalService$callable$loadAllSasScholarshipCandidacies(this, executionYear));
    }

    static /* synthetic */ void advised$loadAllSasScholarshipCandidacies(SicabeExternalService this_, ExecutionYear executionYear) throws DadosAcademicosObterCandidaturasSubmetidasSicabeBusinessMessageFaultFaultMessage, DadosAcademicosObterCandidaturasSubmetidasSicabeErrorMessageFaultFaultMessage, DadosAcademicosObterCandidaturasSubmetidasSicabeValidationMessageFaultFaultMessage, ServerSOAPFaultException {
        ObterCandidaturasSubmetidasRequest parameters = new ObterCandidaturasSubmetidasRequest();
        parameters.setAnoLectivo(executionYear.getAcademicInterval().getStart().getYear());
        ObterCandidaturasSubmetidasResponse obterCandidaturasSubmetidas = ((DadosAcademicos)this_.getClient()).obterCandidaturasSubmetidas(parameters);
        obterCandidaturasSubmetidas.getCandidaturas().getCandidaturaSubmetida().stream().filter(c -> Bennu.getInstance().getSocialServicesConfiguration().getInstitutionCodes().contains(String.valueOf(c.getCodigoInstituicaoEnsino()))).forEach(input -> this.updateOrCreateSasScholarshipCandidacy((CandidaturaSubmetida)input, executionYear));
    }

    private void updateOrCreateSasScholarshipCandidacy(CandidaturaSubmetida input, ExecutionYear executionYear) {
        SasScholarshipCandidacy candidacy = SasScholarshipCandidacy.findAll().stream().filter(c -> c.getExecutionYear() == executionYear && (c.getFiscalNumber().equalsIgnoreCase(input.getNif()) || c.getDocIdType().equalsIgnoreCase(input.getTipoDocumentoIdentificacao().name()) && c.getDocIdNumber().equalsIgnoreCase(input.getNumeroDocumentoIdentificacao())) && c.getDegreeCode().equals(input.getCodigoCurso())).findFirst().orElse(null);
        if (candidacy == null) {
            candidacy = new SasScholarshipCandidacy();
            this.fillCandidacyInfos(input, executionYear, true, candidacy);
        } else if (!this.equalsDataBetweenCandidacyAndInput(candidacy, input)) {
            this.fillCandidacyInfos(input, executionYear, false, candidacy);
        }
    }

    private boolean equalsDataBetweenCandidacyAndInput(SasScholarshipCandidacy candidacy, CandidaturaSubmetida input) {
        return Objects.equal((Object)candidacy.getDegreeCode(), (Object)input.getCodigoCurso()) && Objects.equal((Object)candidacy.getInstitutionCode(), (Object)input.getCodigoInstituicaoEnsino()) && Objects.equal((Object)candidacy.getInstitutionName(), (Object)input.getInstituicaoEnsino()) && Objects.equal((Object)candidacy.getDegreeName(), (Object)input.getCurso()) && Objects.equal((Object)candidacy.getFiscalNumber(), (Object)input.getNif()) && Objects.equal((Object)(candidacy.getSubmissionDate() != null ? candidacy.getSubmissionDate().toString() : null), input.getDataSubmissao() != null ? new DateTime((Object)input.getDataSubmissao().toGregorianCalendar().getTime()).toString() : null) && Objects.equal((Object)candidacy.getTechnicianEmail(), (Object)input.getEmailTecnico().getValue()) && Objects.equal((Object)(candidacy.getAssignmentDate() != null ? candidacy.getAssignmentDate().toString() : null), input.getEstadoCandidatura().getDataAtribuicao() != null ? new DateTime((Object)input.getEstadoCandidatura().getDataAtribuicao().toGregorianCalendar().getTime()).toString() : null) && Objects.equal((Object)candidacy.getDescription(), (Object)input.getEstadoCandidatura().getDescricao().getValue()) && Objects.equal((Object)candidacy.getGratuityAmount(), (Object)input.getEstadoCandidatura().getValorBolsa()) && Objects.equal((Object)candidacy.getCandidacyName(), (Object)input.getNomeCandidato().getValue()) && Objects.equal((Object)candidacy.getTechnicianName(), (Object)input.getNomeTecnico().getValue()) && Objects.equal((Object)candidacy.getStudentNumber(), (Object)input.getNumeroAluno().getValue()) && Objects.equal((Object)candidacy.getCandidacyNumber(), (Object)input.getNumeroCandidatura()) && Objects.equal((Object)candidacy.getDocIdNumber(), (Object)input.getNumeroDocumentoIdentificacao()) && Objects.equal((Object)candidacy.getDocIdType(), (Object)input.getTipoDocumentoIdentificacao().name()) && Objects.equal((Object)candidacy.getCetQualificationOwner(), (Object)((Titularidade)input.getTitularidade().getValue()).isTitularCET()) && Objects.equal((Object)candidacy.getCstpQualificationOwner(), (Object)((Titularidade)input.getTitularidade().getValue()).isTitularCSTP()) && Objects.equal((Object)candidacy.getPhdQualificationOwner(), (Object)((Titularidade)input.getTitularidade().getValue()).isTitularDoutoramento()) && Objects.equal((Object)candidacy.getDegreeQualificationOwner(), (Object)((Titularidade)input.getTitularidade().getValue()).isTitularLicenciatura()) && Objects.equal((Object)candidacy.getMasterQualificationOwner(), (Object)((Titularidade)input.getTitularidade().getValue()).isTitularMestrado());
    }

    private void fillCandidacyInfos(CandidaturaSubmetida input, ExecutionYear executionYear, boolean isNewCandidacy, SasScholarshipCandidacy candidacy) {
        boolean forceUpdateRegistration = !isNewCandidacy && !candidacy.getDegreeCode().equals(input.getCodigoCurso());
        candidacy.setDegreeCode(input.getCodigoCurso());
        candidacy.setInstitutionCode(input.getCodigoInstituicaoEnsino());
        candidacy.setDegreeName(input.getCurso());
        candidacy.setSubmissionDate(input.getDataSubmissao() != null ? new DateTime((Object)input.getDataSubmissao().toGregorianCalendar().getTime()) : null);
        candidacy.setTechnicianEmail((String)input.getEmailTecnico().getValue());
        candidacy.setAssignmentDate(input.getEstadoCandidatura().getDataAtribuicao() != null ? new DateTime((Object)input.getEstadoCandidatura().getDataAtribuicao().toGregorianCalendar().getTime()) : null);
        candidacy.setDescription((String)input.getEstadoCandidatura().getDescricao().getValue());
        candidacy.setCandidacyState(this.convertCandidacyState(input.getEstadoCandidatura().getResultadoEstadoCandidatura()));
        candidacy.setGratuityAmount(input.getEstadoCandidatura().getValorBolsa());
        candidacy.setInstitutionName(input.getInstituicaoEnsino());
        candidacy.setFiscalNumber(input.getNif());
        candidacy.setCandidacyName((String)input.getNomeCandidato().getValue());
        candidacy.setTechnicianName((String)input.getNomeTecnico().getValue());
        if (candidacy.getRegistration() == null) {
            candidacy.setStudentNumber((String)input.getNumeroAluno().getValue());
        }
        candidacy.setCandidacyNumber(input.getNumeroCandidatura());
        candidacy.setDocIdNumber(input.getNumeroDocumentoIdentificacao());
        candidacy.setDocIdType(input.getTipoDocumentoIdentificacao().name());
        candidacy.setCetQualificationOwner(((Titularidade)input.getTitularidade().getValue()).isTitularCET());
        candidacy.setCstpQualificationOwner(((Titularidade)input.getTitularidade().getValue()).isTitularCSTP());
        candidacy.setPhdQualificationOwner(((Titularidade)input.getTitularidade().getValue()).isTitularDoutoramento());
        candidacy.setDegreeQualificationOwner(((Titularidade)input.getTitularidade().getValue()).isTitularLicenciatura());
        candidacy.setMasterQualificationOwner(((Titularidade)input.getTitularidade().getValue()).isTitularMestrado());
        if (executionYear == null) {
            throw new DomainException("error.SicabeExternalService.ExecutionYear.not.found", new String[0]);
        }
        if (isNewCandidacy) {
            executionYear.addSasScholarshipCandidacies(candidacy);
            candidacy.changeState(SasScholarshipCandidacyState.PENDING);
        }
        this.createLogEntry(candidacy, isNewCandidacy ? BundleUtil.getString((String)"resources/SasResources", (String)"message.fillCandidacyInfos.new", (String[])new String[0]) : BundleUtil.getString((String)"resources/SasResources", (String)"message.fillCandidacyInfos.update", (String[])new String[0]), candidacy.getStateDate(), false, false);
        if (candidacy.getRegistration() == null || forceUpdateRegistration) {
            this.associateRegistrationToCandidacy(candidacy);
        }
        candidacy.setImportDate(candidacy.getStateDate());
    }

    private void associateRegistrationToCandidacy(SasScholarshipCandidacy c) {
        FillScholarshipFirstYearService service = new FillScholarshipFirstYearService();
        ScholarshipStudentFirstYearBean tempBean = new ScholarshipStudentFirstYearBean();
        tempBean.setStudentNumber(c.getStudentNumber() != null && NumberUtils.isNumber((String)c.getStudentNumber()) ? Integer.valueOf(c.getStudentNumber()) : null);
        tempBean.setFiscalCode(c.getFiscalNumber());
        tempBean.setStudentName(c.getCandidacyName());
        tempBean.setDegreeCode(c.getDegreeCode() != null ? c.getDegreeCode().trim() : null);
        tempBean.setDocumentNumber(c.getDocIdNumber());
        IDDocumentType candidacyDocumentType = this.convertCandidacyDocumentType(c.getDocIdType());
        tempBean.setDocumentTypeName(candidacyDocumentType != null ? candidacyDocumentType.name() : null);
        try {
            Registration registration = service.getRegistrationByAbstractScholarshipStudentBean(tempBean, c.getExecutionYear());
            if (registration != null) {
                c.setRegistration(registration);
                c.setFirstYear(AbstractFillScholarshipService.isFirstTimeInCycle(registration, c.getExecutionYear()));
            }
        }
        catch (FillScholarshipException e) {
            c.changeState(SasScholarshipCandidacyState.PROCESSED_ERRORS);
        }
        this.writeCandidacyLogs(c, service, tempBean);
    }

    private void writeCandidacyLogs(SasScholarshipCandidacy c, AbstractFillScholarshipService service, AbstractScholarshipStudentBean tempBean) {
        String internalMessages;
        String publicMessages = service.getMessages(tempBean, true);
        if (StringUtils.isNotEmpty((String)publicMessages)) {
            this.createLogEntry(c, publicMessages, c.getStateDate().plus(1L), true, false);
        }
        if (StringUtils.isNotEmpty((String)(internalMessages = service.getMessages(tempBean, false)))) {
            this.createLogEntry(c, internalMessages, c.getStateDate().plus(1L), false, false);
        }
    }

    protected TipoRegime convertRegimeCandidacy(String regime) {
        if (regime.equals("Tempo integral")) {
            return TipoRegime.TEMPO_INTEGRAL;
        }
        if (regime.equals("Trabalhador estudante tempo integral")) {
            return TipoRegime.TRABALHADOR_ESTUDANTE_TEMPO_INTEGRAL;
        }
        if (regime.equals("Tempo parcial")) {
            return TipoRegime.TEMPO_PARCIAL;
        }
        if (regime.equals("Est\u00e1gio Profissional")) {
            return TipoRegime.ESTAGIO_PROFISSIONAL;
        }
        if (regime.equals("Trabalhador estudante tempo parcial")) {
            return TipoRegime.TRABALHADOR_ESTUDANTE_TEMPO_PARCIAL;
        }
        return null;
    }

    protected IDDocumentType convertCandidacyDocumentType(String idDocumentType) {
        if (idDocumentType.equalsIgnoreCase(TipoDocumentoIdentificacao.BI.name())) {
            return IDDocumentType.IDENTITY_CARD;
        }
        if (idDocumentType.equalsIgnoreCase(TipoDocumentoIdentificacao.PASSAPORTE.name())) {
            return IDDocumentType.PASSPORT;
        }
        if (idDocumentType.equalsIgnoreCase(TipoDocumentoIdentificacao.AUTORIZACAO_RESIDENCIA.name())) {
            return IDDocumentType.RESIDENCE_AUTHORIZATION;
        }
        if (idDocumentType.equalsIgnoreCase(TipoDocumentoIdentificacao.BI_NAO_NACIONAL.name())) {
            return IDDocumentType.NATIVE_COUNTRY_IDENTITY_CARD;
        }
        if (idDocumentType.equalsIgnoreCase(TipoDocumentoIdentificacao.OUTROS.name())) {
            return IDDocumentType.OTHER;
        }
        return null;
    }

    protected CandidacyState convertCandidacyState(ResultadoEstadoCandidatura candidacyState) {
        if (candidacyState == ResultadoEstadoCandidatura.INDEFERIDA) {
            return CandidacyState.DISMISSED;
        }
        if (candidacyState == ResultadoEstadoCandidatura.DEFERIDA) {
            return CandidacyState.DEFERRED;
        }
        if (candidacyState == ResultadoEstadoCandidatura.NAO_DETERMINADO) {
            return CandidacyState.UNDEFINED;
        }
        return null;
    }

    public void processAllSasScholarshipCandidacies(ExecutionYear executionYear) {
        Object object = advice$processAllSasScholarshipCandidacies.perform((Callable)new SicabeExternalService$callable$processAllSasScholarshipCandidacies(this, executionYear));
    }

    static /* synthetic */ void advised$processAllSasScholarshipCandidacies(SicabeExternalService this_, ExecutionYear executionYear) {
        SasScholarshipCandidacy.findAll().stream().filter(c -> c.getExecutionYear() == executionYear).forEach(c -> this.fillCandidacyData((SasScholarshipCandidacy)((Object)c)));
    }

    public void processSasScholarshipCandidacies(List<SasScholarshipCandidacy> list) {
        Object object = advice$processSasScholarshipCandidacies.perform((Callable)new SicabeExternalService$callable$processSasScholarshipCandidacies(this, list));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$processSasScholarshipCandidacies(SicabeExternalService this_, List list2Process) {
        list2Process.stream().forEach(c -> this.fillCandidacyData((SasScholarshipCandidacy)((Object)c)));
    }

    private void fillCandidacyData(SasScholarshipCandidacy c) {
        AbstractFillScholarshipService service;
        AbstractScholarshipStudentBean bean;
        if (c.getFirstYear() == null) {
            c.changeState(SasScholarshipCandidacyState.PROCESSED_ERRORS);
            return;
        }
        if (c.getFirstYear().booleanValue()) {
            bean = new ScholarshipStudentFirstYearBean();
            service = new FillScholarshipFirstYearService();
        } else {
            bean = new ScholarshipStudentOtherYearBean();
            service = new FillScholarshipServiceOtherYearService();
        }
        if (c.getRegistration() == null) {
            return;
        }
        bean.setStudentNumber(c.getStudentNumber() != null && NumberUtils.isNumber((String)c.getStudentNumber()) ? Integer.valueOf(c.getStudentNumber()) : null);
        bean.setGratuityAmount(c.getGratuityAmount());
        bean.setCetQualificationOwner(c.getCetQualificationOwner());
        bean.setCtspQualificationOwner(c.getCetQualificationOwner());
        bean.setDegreeQualificationOwner(c.getDegreeQualificationOwner());
        bean.setMasterQualificationOwner(c.getMasterQualificationOwner());
        bean.setPhdQualificationOwner(c.getPhdQualificationOwner());
        bean.setFiscalCode(c.getFiscalNumber());
        bean.setInstitutionCode(c.getInstitutionCode() != null ? String.valueOf(c.getInstitutionCode()) : null);
        bean.setInstitutionName(c.getInstitutionName());
        bean.setCandidacyNumber(c.getCandidacyNumber() != null ? String.valueOf(c.getCandidacyNumber()) : null);
        bean.setStudentName(c.getCandidacyName());
        bean.setDegreeCode(c.getDegreeCode());
        bean.setDegreeName(c.getDegreeName());
        bean.setDocumentNumber(c.getDocIdNumber());
        IDDocumentType candidacyDocumentType = this.convertCandidacyDocumentType(c.getDocIdType());
        bean.setDocumentTypeName(candidacyDocumentType != null ? candidacyDocumentType.name() : null);
        service.fillBeanWithAcademicInfos(bean, c.getRegistration(), c.getExecutionYear(), c.getFirstYear());
        if (c.getSasScholarshipData() == null || this.dataHasChanged(c.getSasScholarshipData(), bean, service)) {
            if (c.getSasScholarshipData() != null) {
                service.addWarningIfRegistrationChangedToInactive(bean, c);
                this.writeCandidacyLogs(c, service, bean);
            }
            this.updateSasSchoolarshipCandidacyData(bean, c);
        }
    }

    private boolean dataHasChanged(SasScholarshipData sasScholarshipData, AbstractScholarshipStudentBean bean, AbstractFillScholarshipService service) {
        boolean value;
        boolean bl = value = !service.equal(bean, bean.getCetQualificationOwner(), sasScholarshipData.getCetQualificationOwner(), "cetQualificationOwner") || !service.equal(bean, bean.getCtspQualificationOwner(), sasScholarshipData.getCtspQualificationOwner(), "ctspQualificationOwner") || !service.equal(bean, bean.getPhdQualificationOwner(), sasScholarshipData.getPhdQualificationOwner(), "phdQualificationOwner") || !service.equal(bean, bean.getDegreeQualificationOwner(), sasScholarshipData.getDegreeQualificationOwner(), "degreeQualificationOwner") || !service.equal(bean, bean.getMasterQualificationOwner(), sasScholarshipData.getMasterQualificationOwner(), "masterQualificationOwner") || !service.equal(bean, bean.getFirstMonthExecutionYear(), sasScholarshipData.getFirstMonthExecutionYear(), "firstMonthExecutionYear") || !service.equal(bean, bean.getGratuityAmount(), sasScholarshipData.getGratuityAmount(), "gratuityAmount") || !service.equal(bean, bean.getCycleNumberOfEnrolmentsYears(), sasScholarshipData.getNumberOfEnrolmentsYears(), "numberOfEnrolmentsYears") || !service.equal(bean, bean.getNumberOfEnrolledECTS(), sasScholarshipData.getNumberOfEnrolledECTS(), "numberOfEnrolledECTS") || !service.equal(bean, bean.getNumberOfMonthsExecutionYear(), sasScholarshipData.getNumberOfMonthsExecutionYear(), "numberOfMonthsExecutionYear") || !service.equal(bean, bean.getCurricularYear(), sasScholarshipData.getCurricularYear(), "curricularYear") || !service.equal(bean, bean.getRegime(), sasScholarshipData.getRegime(), "regime") || !service.equal(bean, bean.getEnroled(), sasScholarshipData.getEnroled(), "enroled") || !service.equal(bean, bean.getNumberOfDegreeCurricularYears(), sasScholarshipData.getNumberOfDegreeCurricularYears(), "numberOfDegreeCurricularYears") || !service.equal(bean, bean.getEnrolmentDate(), sasScholarshipData.getEnrolmentDate(), "enrolmentDate") || !service.equal(bean, bean.getIngressionRegimeCode(), sasScholarshipData.getIngressionRegime(), "ingressionRegime");
        if (bean instanceof ScholarshipStudentOtherYearBean) {
            ScholarshipStudentOtherYearBean otherYearBean = (ScholarshipStudentOtherYearBean)bean;
            value |= !service.equal(otherYearBean, otherYearBean.getNumberOfApprovedEcts(), sasScholarshipData.getNumberOfApprovedEcts(), "numberOfApprovedEcts") || !service.equal(otherYearBean, otherYearBean.getNumberOfApprovedEctsLastYear(), sasScholarshipData.getNumberOfApprovedEctsLastYear(), "numberOfApprovedEctsLastYear") || !service.equal(otherYearBean, otherYearBean.getNumberOfEnrolledEctsLastYear(), sasScholarshipData.getNumberOfEnrolledEctsLastYear(), "numberOfEnrolledEctsLastYear") || !service.equal(otherYearBean, otherYearBean.getNumberOfDegreeChanges(), sasScholarshipData.getNumberOfDegreeChanges(), "numberOfDegreeChanges") || !service.equal(otherYearBean, otherYearBean.getHasMadeDegreeChangeOnCurrentYear(), sasScholarshipData.getHasMadeDegreeChangeOnCurrentYear(), "hasMadeDegreeChangeOnCurrentYear") || !service.equal(otherYearBean, otherYearBean.getLastEnrolmentYear() != null ? String.valueOf(otherYearBean.getLastEnrolmentYear()) : "", sasScholarshipData.getLastEnrolmentYear(), "lastEnrolmentYear") || !service.equal(otherYearBean, otherYearBean.getLastAcademicActDateLastYear(), sasScholarshipData.getLastAcademicActDateLastYear(), "lastAcademicActDateLastYear") || !service.equal(otherYearBean, otherYearBean.getCycleNumberOfEnrolmentsYearsInIntegralRegime(), sasScholarshipData.getCycleNumberOfEnrolmentsYearsInIntegralRegime(), "cycleNumberOfEnrolmentsYearsInIntegralRegime") || !service.equal(otherYearBean, bean.getCycleIngressionYear(), sasScholarshipData.getCycleIngressionYear(), "cycleIngressionYear");
        }
        return value;
    }

    private void updateSasSchoolarshipCandidacyData(AbstractScholarshipStudentBean bean, SasScholarshipCandidacy candidacy) {
        SasScholarshipData data;
        boolean isNewData = false;
        if (candidacy.getSasScholarshipData() == null) {
            data = new SasScholarshipData();
            candidacy.setSasScholarshipData(data);
            isNewData = true;
        } else {
            data = candidacy.getSasScholarshipData();
        }
        candidacy.setStudentNumber(bean.getStudentNumber() != null ? String.valueOf(bean.getStudentNumber()) : "");
        data.setGratuityAmount(bean.getGratuityAmount());
        data.setNumberOfMonthsExecutionYear(bean.getNumberOfMonthsExecutionYear());
        data.setFirstMonthExecutionYear(bean.getFirstMonthExecutionYear());
        data.setIngressionRegime(bean.getIngressionRegimeCode());
        data.setRegime(bean.getRegime());
        data.setEnroled(bean.getEnroled());
        data.setEnrolmentDate(bean.getEnrolmentDate());
        data.setNumberOfEnrolledECTS(bean.getNumberOfEnrolledECTS());
        data.setCetQualificationOwner(bean.getCetQualificationOwner());
        data.setCtspQualificationOwner(bean.getCtspQualificationOwner());
        data.setDegreeQualificationOwner(bean.getDegreeQualificationOwner());
        data.setMasterQualificationOwner(bean.getMasterQualificationOwner());
        data.setPhdQualificationOwner(bean.getPhdQualificationOwner());
        data.setCycleIngressionYear(bean.getCycleIngressionYear());
        data.setNumberOfEnrolmentsYears(bean.getCycleNumberOfEnrolmentsYears());
        data.setNumberOfDegreeCurricularYears(bean.getNumberOfDegreeCurricularYears());
        data.setObservations(bean.getObservations());
        data.setCurricularYear(bean.getCurricularYear());
        if (bean instanceof ScholarshipStudentOtherYearBean) {
            ScholarshipStudentOtherYearBean otherYearBean = (ScholarshipStudentOtherYearBean)bean;
            data.setNumberOfDegreeChanges(otherYearBean.getNumberOfDegreeChanges());
            data.setHasMadeDegreeChangeOnCurrentYear(otherYearBean.getHasMadeDegreeChangeOnCurrentYear());
            data.setNumberOfEnrolledEctsLastYear(otherYearBean.getNumberOfEnrolledEctsLastYear());
            data.setNumberOfApprovedEctsLastYear(otherYearBean.getNumberOfApprovedEctsLastYear());
            data.setLastEnrolmentYear(String.valueOf(otherYearBean.getLastEnrolmentYear()));
            data.setLastAcademicActDateLastYear(otherYearBean.getLastAcademicActDateLastYear());
            data.setCycleNumberOfEnrolmentsYearsInIntegralRegime(otherYearBean.getCycleNumberOfEnrolmentsYearsInIntegralRegime());
            data.setNumberOfApprovedEcts(otherYearBean.getNumberOfApprovedEcts());
        }
        if (data.getObservations().contains("ERRO")) {
            candidacy.changeState(SasScholarshipCandidacyState.PROCESSED_ERRORS);
        } else if (data.getObservations().contains("AVISO")) {
            candidacy.changeState(SasScholarshipCandidacyState.PROCESSED_WARNINGS);
        } else {
            candidacy.changeState(SasScholarshipCandidacyState.PROCESSED);
        }
        this.createLogEntry(candidacy, (String)(StringUtils.isNotEmpty((String)data.getObservations()) ? data.getObservations() : (isNewData ? BundleUtil.getString((String)"resources/SasResources", (String)"message.updateSasSchoolarshipCandidacyData.new", (String[])new String[0]) : BundleUtil.getString((String)"resources/SasResources", (String)"message.updateSasSchoolarshipCandidacyData.update", (String[])new String[0]) + (StringUtils.isNotEmpty((String)data.getObservations()) ? data.getObservations() : ""))), candidacy.getStateDate(), false, false);
    }

    public void sendSasScholarshipsCandidaciesToSicabe(Collection<SasScholarshipCandidacy> list2Process) {
        this.sendSasScholarshipsCandidaciesToSicabe(list2Process, false);
    }

    public void sendSasScholarshipsCandidaciesToSicabe(Collection<SasScholarshipCandidacy> list2Process, boolean forceSend) {
        boolean errors = false;
        for (SasScholarshipCandidacy candidacy : list2Process) {
            try {
                this.sendCandidacyToSicabe(candidacy, forceSend);
            }
            catch (Throwable e) {
                errors = true;
                this.createLogEntry(candidacy, e.getMessage(), new DateTime(), false, false);
            }
        }
        if (errors) {
            throw new RuntimeException(SasPTUtil.bundle("label.error.send", new String[0]));
        }
    }

    private void sendCandidacyToSicabe(SasScholarshipCandidacy sasScholarshipCandidacy, boolean bl) {
        Object object = advice$sendCandidacyToSicabe.perform((Callable)new SicabeExternalService$callable$sendCandidacyToSicabe(this, sasScholarshipCandidacy, bl));
    }

    static /* synthetic */ void advised$sendCandidacyToSicabe(SicabeExternalService this_, SasScholarshipCandidacy c, boolean forceSend) {
        if (!forceSend && !this_.stateAllowToSendCandicacy(c.getState())) {
            throw new RuntimeException(BundleUtil.getString((String)"resources/SasResources", (String)"message.error.sendCandidacy2Sicabe", (String[])new String[]{c.getState() != null ? c.getState().getLocalizedName() : "-"}));
        }
        try {
            if (c.getFirstYear().booleanValue()) {
                this_.sendFirstTimeAcademicData(c);
            } else {
                this_.sendOtherAcademicData(c);
            }
            c.changeState(SasScholarshipCandidacyState.SENT);
            DateTime exportDate = new DateTime();
            c.setExportDate(exportDate);
            this_.createLogEntry(c, BundleUtil.getString((String)"resources/SasResources", (String)"message.success.sendCandidacy2Sicabe", (String[])new String[0]), exportDate, false, true);
        }
        catch (DadosAcademicosAlterarDadosAcademicosPrimeiraVezSicabeBusinessMessageFaultFaultMessage | DadosAcademicosAlterarDadosAcademicosPrimeiraVezSicabeErrorMessageFaultFaultMessage | DadosAcademicosAlterarDadosAcademicosPrimeiraVezSicabeValidationMessageFaultFaultMessage | DadosAcademicosAlterarDadosAcademicosRestantesCasosSicabeBusinessMessageFaultFaultMessage | DadosAcademicosAlterarDadosAcademicosRestantesCasosSicabeErrorMessageFaultFaultMessage | DadosAcademicosAlterarDadosAcademicosRestantesCasosSicabeValidationMessageFaultFaultMessage e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private boolean stateAllowToSendCandicacy(SasScholarshipCandidacyState state) {
        return state == SasScholarshipCandidacyState.PROCESSED || state == SasScholarshipCandidacyState.PROCESSED_WARNINGS;
    }

    public boolean removeAllSasScholarshipsCandidacies(ExecutionYear executionYear) {
        return (Boolean)advice$removeAllSasScholarshipsCandidacies.perform((Callable)new SicabeExternalService$callable$removeAllSasScholarshipsCandidacies(this, executionYear));
    }

    static /* synthetic */ boolean advised$removeAllSasScholarshipsCandidacies(SicabeExternalService this_, ExecutionYear executionYear) {
        List candidacies2Remove = SasScholarshipCandidacy.findAll().stream().filter(c -> c.getExecutionYear() == executionYear).collect(Collectors.toList());
        boolean warningMessage = false;
        for (SasScholarshipCandidacy current : candidacies2Remove) {
            try {
                this_.removeSasScholarshipsCandidacy(current);
            }
            catch (FillScholarshipException e) {
                warningMessage = true;
            }
        }
        return warningMessage;
    }

    public void removeSasScholarshipsCandidacy(SasScholarshipCandidacy sasScholarshipCandidacy) {
        Object object = advice$removeSasScholarshipsCandidacy.perform((Callable)new SicabeExternalService$callable$removeSasScholarshipsCandidacy(this, sasScholarshipCandidacy));
    }

    static /* synthetic */ void advised$removeSasScholarshipsCandidacy(SicabeExternalService this_, SasScholarshipCandidacy c) {
        if (c.getExportDate() != null) {
            throw new FillScholarshipException("label.error.delete.already.sent", new String[0]);
        }
        c.delete();
    }

    private void sendFirstTimeAcademicData(SasScholarshipCandidacy candidacy) throws DadosAcademicosAlterarDadosAcademicosPrimeiraVezSicabeBusinessMessageFaultFaultMessage, DadosAcademicosAlterarDadosAcademicosPrimeiraVezSicabeErrorMessageFaultFaultMessage, DadosAcademicosAlterarDadosAcademicosPrimeiraVezSicabeValidationMessageFaultFaultMessage {
        SasScholarshipData data = candidacy.getSasScholarshipData();
        AlterarDadosAcademicosPrimeiraVezRequest request = new AlterarDadosAcademicosPrimeiraVezRequest();
        request.setAnoInscricaoCurso(data.getCycleIngressionYear());
        request.setCodigoCurso(data.getSasScholarshipCandidacy().getDegreeCode());
        request.setCodigoInstituicaoEnsino(candidacy.getInstitutionCode());
        request.setDataInscricaoAnoLectivo(this.createXMLGregorianCalendar(data.getEnrolmentDate()));
        IdentificadorCandidatura idCandidatura = this.createIdentificadorCandidaturaData(candidacy.getExecutionYear().getAcademicInterval().getStart().getYear(), candidacy.getDocIdNumber(), candidacy.getDocIdType(), candidacy.getFiscalNumber());
        request.setIdentificadorCandidatura(idCandidatura);
        request.setIInscritoAnoLectivoActual(data.getEnroled());
        request.setMesPrimeiroPagamento(data.getFirstMonthExecutionYear());
        request.setNumeroAluno(candidacy.getStudentNumber());
        request.setNumeroAnosCurso(data.getNumberOfDegreeCurricularYears());
        request.setNumeroECTSActualInscrito(data.getNumberOfEnrolledECTS());
        request.setNumeroMatriculas(1);
        request.setNumeroMesesPropina(data.getNumberOfMonthsExecutionYear());
        String observationToSend = this.getObservationToSend(candidacy);
        request.setObservacoes(observationToSend != null ? new ObjectFactory().createAlterarDadosAcademicosPrimeiraVezRequestObservacoes(observationToSend) : null);
        request.setRegime(this.convertRegimeCandidacy(data.getRegime()));
        request.setCodRegimeIngresso(Integer.valueOf(data.getIngressionRegime()));
        request.setTitularCET(data.getCetQualificationOwner());
        request.setTitularCSTP(data.getCtspQualificationOwner());
        request.setTitularDoutoramento(data.getPhdQualificationOwner());
        request.setTitularLicenciatura(data.getDegreeQualificationOwner());
        request.setTitularMestrado(data.getMasterQualificationOwner());
        request.setValorPropina(data.getGratuityAmount());
        ((DadosAcademicos)this.getClient()).alterarDadosAcademicosPrimeiraVez(request);
    }

    private String getObservationToSend(SasScholarshipCandidacy candidacy) {
        return candidacy.getLogsAfter(candidacy.getSubmissionDate(), true).stream().sorted(SasScholarshipDataChangeLog.COMPARATOR_BY_DATE.reversed()).map(l -> l.getDescription()).distinct().collect(Collectors.joining("\n"));
    }

    protected XMLGregorianCalendar createXMLGregorianCalendar(LocalDate localDate) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(localDate.toDate().getTime());
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar newXMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            return newXMLGregorianCalendar;
        }
        catch (DatatypeConfigurationException e) {
            return null;
        }
    }

    protected IdentificadorCandidatura createIdentificadorCandidaturaData(Integer beginExecutionYear, String docIdNumber, String docIdType, String fiscalNumber) {
        ObjectFactory factory = new ObjectFactory();
        IdentificadorCandidatura idCandidatura = new IdentificadorCandidatura();
        idCandidatura.setAnoLectivo(beginExecutionYear);
        idCandidatura.setDocumentoIdentificacao(factory.createIdentificadorCandidaturaDocumentoIdentificacao(docIdNumber));
        idCandidatura.setTipoDocumentoIdentificacao(TipoDocumentoIdentificacao.valueOf(docIdType));
        idCandidatura.setNif(factory.createIdentificadorCandidaturaNif(fiscalNumber));
        return idCandidatura;
    }

    private void sendOtherAcademicData(SasScholarshipCandidacy candidacy) throws DadosAcademicosAlterarDadosAcademicosRestantesCasosSicabeBusinessMessageFaultFaultMessage, DadosAcademicosAlterarDadosAcademicosRestantesCasosSicabeErrorMessageFaultFaultMessage, DadosAcademicosAlterarDadosAcademicosRestantesCasosSicabeValidationMessageFaultFaultMessage {
        SasScholarshipData data = candidacy.getSasScholarshipData();
        AlterarDadosAcademicosRestantesCasosRequest request = new AlterarDadosAcademicosRestantesCasosRequest();
        request.setAnoInscricaoCurso(data.getCycleIngressionYear());
        request.setAnoLectivoActual(data.getCurricularYear());
        request.setCodigoCurso(candidacy.getDegreeCode());
        request.setCodigoInstituicaoEnsino(candidacy.getInstitutionCode());
        request.setDataConclusaoAtosAcademicosUltimoAnoLectivoInscrito(this.createXMLGregorianCalendar(data.getLastAcademicActDateLastYear()));
        request.setDataInscricaoAnoLectivo(this.createXMLGregorianCalendar(data.getEnrolmentDate()));
        IdentificadorCandidatura idCandidatura = this.createIdentificadorCandidaturaData(candidacy.getExecutionYear().getAcademicInterval().getStart().getYear(), candidacy.getDocIdNumber(), candidacy.getDocIdType(), candidacy.getFiscalNumber());
        request.setIdentificadorCandidatura(idCandidatura);
        request.setIInscritoAnoLectivoActual(data.getEnroled());
        request.setMesPrimeiroPagamento(data.getFirstMonthExecutionYear());
        request.setNumeroAluno(candidacy.getStudentNumber());
        request.setNumeroAnosCurso(data.getNumberOfDegreeCurricularYears());
        request.setNumeroECTSActualmenteInscrito(data.getNumberOfEnrolledECTS());
        request.setNumeroECTSObtidosUltimoAnoInscrito(data.getNumberOfApprovedEctsLastYear());
        request.setNumeroECTSUltimoAnoInscrito(data.getNumberOfEnrolledEctsLastYear());
        request.setNumeroInscricoesCicloEstudosTempoIntegral(data.getCycleNumberOfEnrolmentsYearsInIntegralRegime());
        request.setNumeroMatriculas(data.getNumberOfEnrolmentsYears());
        request.setNumeroMesesPropina(data.getNumberOfMonthsExecutionYear());
        request.setNumeroOcorrenciasMudancaCurso(data.getNumberOfDegreeChanges());
        String observationToSend = this.getObservationToSend(candidacy);
        request.setObservacoes(observationToSend != null ? new ObjectFactory().createAlterarDadosAcademicosRestantesCasosRequestObservacoes(observationToSend) : null);
        request.setPresenteAnoMudouDeCurso(data.getHasMadeDegreeChangeOnCurrentYear());
        request.setRegime(this.convertRegimeCandidacy(data.getRegime()));
        request.setCodRegimeIngresso(Integer.valueOf(data.getIngressionRegime()));
        request.setTitularCET(data.getCetQualificationOwner());
        request.setTitularCSTP(data.getCtspQualificationOwner());
        request.setTitularDoutoramento(data.getPhdQualificationOwner());
        request.setTitularLicenciatura(data.getDegreeQualificationOwner());
        request.setTitularMestrado(data.getMasterQualificationOwner());
        request.setTotalECTScursoAtingirGrau(data.getNumberOfApprovedEcts());
        request.setUltimoAnoInscrito(Integer.valueOf(data.getLastEnrolmentYear()));
        request.setValorPropina(data.getGratuityAmount());
        ((DadosAcademicos)this.getClient()).alterarDadosAcademicosRestantesCasos(request);
    }

    private void sendRegistrationStudent(SasScholarshipCandidacy candidacy) {
        RegistarMatriculaAlunoRequest request = new RegistarMatriculaAlunoRequest();
        request.setCodigoCurso(candidacy.getRegistration().getDegree().getMinistryCode());
        request.setCodigoInstituicaoEnsino(-1);
        request.setDataMatricula(null);
        IdentificadorCandidatura idCandidatura = this.createIdentificadorCandidaturaData(null, candidacy.getDocIdNumber(), candidacy.getDocIdType(), candidacy.getFiscalNumber());
        request.setIdentificadorCandidatura(idCandidatura);
    }

    private void updateCandidacyState(SasScholarshipCandidacy candidacy) {
        ObterEstadoCandidaturaRequest request = new ObterEstadoCandidaturaRequest();
        IdentificadorCandidatura idCandidatura = this.createIdentificadorCandidaturaData(null, candidacy.getDocIdNumber(), candidacy.getDocIdType(), candidacy.getFiscalNumber());
        request.setIdentificadorCandidatura(idCandidatura);
    }

    private void getSubmittedCandidacies(SasScholarshipCandidacy candidacy) {
        ObterEstadoCandidaturaRequest request = new ObterEstadoCandidaturaRequest();
        IdentificadorCandidatura idCandidatura = this.createIdentificadorCandidaturaData(null, candidacy.getDocIdNumber(), candidacy.getDocIdType(), candidacy.getFiscalNumber());
        request.setIdentificadorCandidatura(idCandidatura);
    }

    private void changeInstitutionDegree(SasScholarshipCandidacy candidacy) {
        ObjectFactory factory = new ObjectFactory();
        AlterarCursoInsituicaoRequest request = new AlterarCursoInsituicaoRequest();
        IdentificadorCandidatura idCandidatura = this.createIdentificadorCandidaturaData(null, candidacy.getDocIdNumber(), candidacy.getDocIdType(), candidacy.getFiscalNumber());
        request.setIdentificadorCandidatura(idCandidatura);
        request.setIdentificadorCandidatura(idCandidatura);
        request.setCodigoCurso(candidacy.getRegistration().getDegree().getMinistryCode());
        request.setCodigoInstituicaoEnsino(-1);
        request.setDataMudanca(null);
    }

    public static byte[] export(ExecutionYear executionYear) {
        SpreadsheetBuilderForXLSX builder = new SpreadsheetBuilderForXLSX();
        builder.addSheet("SAS", new SheetDataExtension(executionYear.getSasScholarshipCandidaciesSet()));
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            builder.build(result);
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAllowedToSend(SasScholarshipCandidacy candidacy) {
        return this.stateAllowToSendCandicacy(candidacy.getState());
    }

    private void createLogEntry(SasScholarshipCandidacy sasScholarshipCandidacy, String string, DateTime dateTime, boolean bl, boolean bl2) {
        Object object = advice$createLogEntry.perform((Callable)new SicabeExternalService$callable$createLogEntry(this, sasScholarshipCandidacy, string, dateTime, bl, bl2));
    }

    static /* synthetic */ void advised$createLogEntry(SicabeExternalService this_, SasScholarshipCandidacy candidacy, String message, DateTime date, boolean publicLog, boolean sentLog) {
        new SasScholarshipDataChangeLog(candidacy, date, message, publicLog, sentLog);
    }

    private static String bundle(String key) {
        return SasPTUtil.bundle(key, new String[0]);
    }

    public static final class SheetDataExtension
    extends SheetData<SasScholarshipCandidacy> {
        private SheetDataExtension(Iterable<SasScholarshipCandidacy> items) {
            super(items);
        }

        protected void makeLine(SasScholarshipCandidacy candidacy) {
            SasScholarshipData data = candidacy.getSasScholarshipData();
            this.addData("SasScholarshipCandidacy.candidacyName", candidacy.getCandidacyName());
            this.addData("SasScholarshipCandidacy.docIdNumber", candidacy.getDocIdNumber());
            this.addData("SasScholarshipCandidacy.docIdType", candidacy.getDocIdType());
            this.addData("SasScholarshipCandidacy.fiscalNumber", candidacy.getFiscalNumber());
            this.addData("SasScholarshipCandidacy.stateDate", this.format(candidacy.getStateDate()));
            this.addData("SasScholarshipCandidacy.exportDate", this.format(candidacy.getExportDate()));
            this.addData("SasScholarshipCandidacy.assignmentDate", this.format(candidacy.getAssignmentDate()));
            this.addData("SasScholarshipCandidacy.candidacyState", candidacy.getCandidacyState().getLocalizedName());
            this.addData("SasScholarshipCandidacy.description", candidacy.getDescription());
            Registration registration = candidacy.getRegistration();
            if (registration != null) {
                this.addData("SasScholarshipCandidacy.studentNumber", registration.getNumber() != null ? registration.getNumber().toString() : "-");
                this.addData("SasScholarshipCandidacy.degreeCode", registration.getDegree() != null ? registration.getDegree().getCode() : "");
                this.addData("SasScholarshipCandidacy.degreeName", registration.getDegree() != null ? registration.getDegree().getPresentationName() : "");
            } else {
                this.addData("SasScholarshipCandidacy.studentNumber", candidacy.getStudentNumber());
                this.addData("SasScholarshipCandidacy.degreeCode", candidacy.getDegreeCode());
                this.addData("SasScholarshipCandidacy.degreeName", candidacy.getDegreeName());
            }
            this.addData("SasScholarshipData.state", candidacy.getState().getLocalizedName() + (candidacy.isModified() ? " *" : ""));
            List logs = candidacy.getSasScholarshipDataChangeLogsSet().stream().sorted((x, y) -> -x.getDate().compareTo((ReadableInstant)y.getDate())).collect(Collectors.toList());
            List sentLogs = logs.stream().filter(l -> l.getSentLog()).collect(Collectors.toList());
            ArrayList logsToExcel = logs.size() == 0 ? new ArrayList() : logs.subList(0, sentLogs.size() < 2 ? logs.size() - 1 : logs.indexOf(sentLogs.get(1)));
            this.addData("event.logs", logsToExcel.stream().map(SasScholarshipDataChangeLog_Base::getDescription).collect(Collectors.joining("\n")));
            if (data != null) {
                this.addData("SasScholarshipCandidacy.firstYear", candidacy.getFirstYear() != false ? SicabeExternalService.bundle("label.true") : SicabeExternalService.bundle("label.false"));
                this.addData("SasScholarshipData.cycleIngressionYear", data.getCycleIngressionYear() != null ? data.getCycleIngressionYear().toString() : "");
                this.addData("SasScholarshipData.curricularYear", data.getCurricularYear());
                this.addData("SasScholarshipData.lastAcademicActDateLastYear", this.format(data.getLastAcademicActDateLastYear()));
                this.addData("SasScholarshipData.enrolmentDate", this.format(data.getEnrolmentDate()));
                this.addData("SasScholarshipData.firstMonthExecutionYear", data.getFirstMonthExecutionYear());
                this.addData("SasScholarshipData.numberOfDegreeCurricularYears", data.getNumberOfDegreeCurricularYears());
                this.addData("SasScholarshipData.numberOfEnrolledECTS", data.getNumberOfEnrolledECTS());
                this.addData("SasScholarshipData.numberOfApprovedEctsLastYear", data.getNumberOfApprovedEctsLastYear());
                this.addData("SasScholarshipData.numberOfEnrolledEctsLastYear", data.getNumberOfEnrolledEctsLastYear());
                this.addData("SasScholarshipData.numberOfEnrolmentsYears", data.getNumberOfEnrolmentsYears());
                this.addData("SasScholarshipData.cycleNumberOfEnrolmentsYearsInIntegralRegime", data.getCycleNumberOfEnrolmentsYearsInIntegralRegime());
                this.addData("SasScholarshipData.numberOfMonthsExecutionYear", data.getNumberOfMonthsExecutionYear());
                this.addData("SasScholarshipData.numberOfDegreeChanges", data.getNumberOfDegreeChanges());
                this.addData("SasScholarshipData.observations", data.getObservations());
                this.addData("SasScholarshipData.hasMadeDegreeChangeOnCurrentYear", this.format(data.getHasMadeDegreeChangeOnCurrentYear()));
                this.addData("SasScholarshipData.regime", data.getRegime());
                this.addData("SasScholarshipData.cetQualificationOwner", this.format(data.getCetQualificationOwner()));
                this.addData("SasScholarshipData.ctspQualificationOwner", this.format(data.getCtspQualificationOwner()));
                this.addData("SasScholarshipData.phdQualificationOwner", this.format(data.getPhdQualificationOwner()));
                this.addData("SasScholarshipData.degreeQualificationOwner", this.format(data.getDegreeQualificationOwner()));
                this.addData("SasScholarshipData.masterQualificationOwner", this.format(data.getMasterQualificationOwner()));
                this.addData("SasScholarshipData.lastEnrolmentYear", data.getLastEnrolmentYear());
                this.addData("SasScholarshipData.gratuityAmount", data.getGratuityAmount());
                this.addData("SasScholarshipData.enroled", this.format(data.getEnroled()));
                this.addData("SasScholarshipData.numberOfApprovedEcts", data.getNumberOfApprovedEcts());
                this.addData("SasScholarshipData.ingressionRegime", data.getIngressionRegime());
            } else {
                String[] fields = new String[]{"SasScholarshipCandidacy.firstYear", "SasScholarshipData.cycleIngressionYear", "SasScholarshipData.curricularYear", "SasScholarshipData.lastAcademicActDateLastYear", "SasScholarshipData.enrolmentDate", "SasScholarshipData.firstMonthExecutionYear", "SasScholarshipData.numberOfDegreeCurricularYears", "SasScholarshipData.numberOfEnrolledECTS", "SasScholarshipData.numberOfApprovedEctsLastYear", "SasScholarshipData.numberOfEnrolledEctsLastYear", "SasScholarshipData.numberOfEnrolmentsYears", "SasScholarshipData.cycleNumberOfEnrolmentsYearsInIntegralRegime", "SasScholarshipData.numberOfMonthsExecutionYear", "SasScholarshipData.numberOfDegreeChanges", "SasScholarshipData.observations", "SasScholarshipData.hasMadeDegreeChangeOnCurrentYear", "SasScholarshipData.regime", "SasScholarshipData.cetQualificationOwner", "SasScholarshipData.ctspQualificationOwner", "SasScholarshipData.phdQualificationOwner", "SasScholarshipData.degreeQualificationOwner", "SasScholarshipData.masterQualificationOwner", "SasScholarshipData.lastEnrolmentYear", "SasScholarshipData.gratuityAmount", "SasScholarshipData.enroled", "SasScholarshipData.numberOfApprovedEcts", "SasScholarshipData.ingressionRegime"};
                Arrays.stream(fields).forEach(f -> this.addData((String)f, "-"));
            }
        }

        private String format(Boolean value) {
            return value == null ? null : (value != false ? SicabeExternalService.bundle("label.true") : SicabeExternalService.bundle("label.false"));
        }

        private LocalDate format(LocalDate value) {
            return value;
        }

        private LocalDate format(DateTime value) {
            return value != null ? value.toLocalDate() : null;
        }

        private void addData(String key, Object value) {
            this.addCell(SicabeExternalService.bundle("label." + key), value == null ? "" : value);
        }
    }
}

