/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.commons.export;

import com.qubit.terra.framework.services.logging.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.fenixedu.legalpt.domain.report.LegalReportRequest;
import org.fenixedu.legalpt.domain.report.LegalReportResultFile;
import org.fenixedu.legalpt.domain.report.LegalReportResultFileType;
import org.fenixedu.legalpt.services.commons.export.XmlZipFileWriter$callable$writeToFile;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class XmlZipFileWriter {
    public static final Advice advice$writeToFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public static LegalReportResultFile write(LegalReportRequest reportRequest, LegalReportResultFile xmlResultFile, String password) {
        byte[] baos = XmlZipFileWriter.createEncryptedZip(xmlResultFile.getFilename(), xmlResultFile.getContent(), password);
        return baos == null ? null : XmlZipFileWriter.writeToFile(reportRequest, xmlResultFile, baos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] createEncryptedZip(String fileName, byte[] content, String password) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ZipParameters parameters = new ZipParameters();
                parameters.setCompressionMethod(CompressionMethod.DEFLATE);
                parameters.setCompressionLevel(CompressionLevel.NORMAL);
                parameters.setEncryptFiles(true);
                parameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
                parameters.setFileNameInZip(fileName);
                try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)baos, password.toCharArray());){
                    zipOutputStream.putNextEntry(parameters);
                    zipOutputStream.write(content);
                }
                catch (IOException e) {
                    Log.error((String)"Error while creating zip output stream", (Throwable)e);
                    byte[] byArray = null;
                    baos.close();
                    return byArray;
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            finally {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    Throwable throwable;
                    throwable.addSuppressed(throwable2);
                }
            }
        }
        catch (IOException e) {
            Log.error((String)"Error while creating byte array output stream", (Throwable)e);
            return null;
        }
    }

    private static LegalReportResultFile writeToFile(LegalReportRequest legalReportRequest, LegalReportResultFile legalReportResultFile, byte[] byArray) {
        return (LegalReportResultFile)((Object)advice$writeToFile.perform((Callable)new XmlZipFileWriter$callable$writeToFile(legalReportRequest, legalReportResultFile, byArray)));
    }

    static /* synthetic */ LegalReportResultFile advised$writeToFile(LegalReportRequest reportRequest, LegalReportResultFile xmlResultFile, byte[] baos) {
        return new LegalReportResultFile(reportRequest, LegalReportResultFileType.ZIP, xmlResultFile.getFilename().replace(".xml", ".zip"), baos);
    }
}

