/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.raides;

import java.math.RoundingMode;
import java.util.LinkedHashMap;
import java.util.Map;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.legalpt.domain.ReportEntryTarget;

public class RaidesReportEntryTarget
implements ReportEntryTarget {
    private Registration registration;
    private ExecutionYear executionYear;
    private static final RaidesReportEntryTarget EMPTY = new RaidesReportEntryTarget(){

        @Override
        public Map<String, String> asMap() {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            result.put("N\u00ba de Aluno", "");
            result.put("N\u00ba de Matr\u00edcula", "");
            result.put("C\u00f3digo de Curso", "");
            result.put("Curso", "");
            result.put("Ano", "");
            result.put("ECTS realizados", "");
            result.put("Ano Curricular", "");
            return result;
        }
    };

    protected RaidesReportEntryTarget() {
    }

    public RaidesReportEntryTarget(Registration registration, ExecutionYear executionYear) {
        this.registration = registration;
        this.executionYear = executionYear;
    }

    @Override
    public Map<String, String> asMap() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("N\u00ba de Aluno", this.registration.getStudent().getNumber().toString());
        result.put("N\u00ba de Matr\u00edcula", this.registration.getNumber().toString());
        result.put("C\u00f3digo de Curso", this.registration.getDegree().getCode());
        result.put("Curso", this.registration.getDegree().getPresentationName());
        result.put("Ano", this.executionYear.getQualifiedName());
        result.put("ECTS realizados", this.registration.getStudentCurricularPlan(this.executionYear).getRoot().getCurriculum(this.executionYear).getSumEctsCredits().setScale(1, RoundingMode.HALF_UP).toString());
        result.put("Ano Curricular", String.valueOf(RegistrationServices.getCurricularYear((Registration)this.registration, (ExecutionYear)this.executionYear).getResult()));
        return result;
    }

    public static RaidesReportEntryTarget of(Registration registration, ExecutionYear executionYear) {
        return new RaidesReportEntryTarget(registration, executionYear);
    }

    public static RaidesReportEntryTarget empty() {
        return EMPTY;
    }
}

