/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse.components;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.BibliographicReference;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.executionCourse.components.BaseExecutionCourseComponent;

@ComponentType(name="bibliographicReferences", description="Bibliographic References for an Execution Course")
public class BibliographicReferencesComponent
extends BaseExecutionCourseComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        ExecutionCourse executionCourse = page.getSite().getExecutionCourse();
        Map<Boolean, List<BibliographicReference>> bibliographicReferencesByOptional = this.bibliographicReferences(executionCourse);
        globalContext.put((Object)"executionCourse", (Object)executionCourse);
        globalContext.put((Object)"mainReferences", bibliographicReferencesByOptional.get(false));
        globalContext.put((Object)"secondaryReferences", bibliographicReferencesByOptional.get(true));
        globalContext.put((Object)"optionalReferences", Collections.emptyList());
        globalContext.put((Object)"nonOptionalReferences", Collections.emptyList());
    }

    private Map<Boolean, List<BibliographicReference>> bibliographicReferences(ExecutionCourse executionCourse) {
        return executionCourse.getCompetenceCourses().stream().flatMap(cc -> cc.findBibliographies()).sorted(BibliographicReference.COMPARATOR_BY_ORDER).collect(Collectors.partitioningBy(br -> br.isOptional()));
    }
}

