/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse;

import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.Menu;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.component.ListCategoryPosts;
import org.fenixedu.cms.domain.component.ViewPost;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.learning.domain.executionCourse.ExecutionCourseSiteBuilder_Base;
import org.fenixedu.learning.domain.executionCourse.components.BibliographicReferencesComponent;
import org.fenixedu.learning.domain.executionCourse.components.EvaluationMethodsComponent;
import org.fenixedu.learning.domain.executionCourse.components.EvaluationsComponent;
import org.fenixedu.learning.domain.executionCourse.components.ExecutionCourseComponent;
import org.fenixedu.learning.domain.executionCourse.components.GroupsComponent;
import org.fenixedu.learning.domain.executionCourse.components.InitialPageComponent;
import org.fenixedu.learning.domain.executionCourse.components.LessonPlanComponent;
import org.fenixedu.learning.domain.executionCourse.components.ObjectivesComponent;
import org.fenixedu.learning.domain.executionCourse.components.ScheduleComponent;

public class ExecutionCourseSiteBuilder
extends ExecutionCourseSiteBuilder_Base {
    public static final String BUNDLE = "resources.FenixEduLearningResources";
    public static final LocalizedString ANNOUNCEMENTS_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.announcements", (String[])new String[0]);
    public static final LocalizedString VIEW_POST_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.viewPost", (String[])new String[0]);
    private static final LocalizedString INITIAL_PAGE_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.initialPage", (String[])new String[0]);
    private static final LocalizedString GROUPS_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.groups", (String[])new String[0]);
    private static final LocalizedString EVALUATIONS_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.evaluations", (String[])new String[0]);
    private static final LocalizedString REFERENCES_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.bibliographicReferences", (String[])new String[0]);
    private static final LocalizedString SCHEDULE_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.schedule", (String[])new String[0]);
    private static final LocalizedString EVALUATION_METHOD_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.evaluationMethods", (String[])new String[0]);
    private static final LocalizedString OBJECTIVES_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.objectives", (String[])new String[0]);
    private static final LocalizedString MARKS_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.marks", (String[])new String[0]);
    private static final LocalizedString LESSON_PLAN_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.lessonsPlanings", (String[])new String[0]);
    private static final LocalizedString PROGRAM_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.program", (String[])new String[0]);
    private static final LocalizedString SUMMARIES_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.summaries", (String[])new String[0]);
    private static final LocalizedString SHIFTS_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.shifts", (String[])new String[0]);
    public static final LocalizedString MENU_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.menu", (String[])new String[0]);
    public static final LocalizedString EXTRA_MENU_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.extra.menu", (String[])new String[0]);

    private ExecutionCourseSiteBuilder() {
        this.setSlug(ExecutionCourseSiteBuilder.class.getSimpleName());
        Bennu.getInstance().getSiteBuildersSet().add(this);
    }

    public static ExecutionCourseSiteBuilder getInstance() {
        return Bennu.getInstance().getSiteBuildersSet().stream().filter(siteBuilder -> siteBuilder instanceof ExecutionCourseSiteBuilder).map(siteBuilder -> (ExecutionCourseSiteBuilder)((Object)siteBuilder)).findFirst().orElseGet(() -> new ExecutionCourseSiteBuilder());
    }

    public Site create(LocalizedString name, LocalizedString description, String slug) {
        Site site = super.create(name, description);
        site.setSlug(slug);
        Menu menu = new Menu(site, MENU_TITLE);
        menu.setPrivileged(true);
        menu.setOrder(Integer.valueOf(0));
        site.setSystemMenu(menu);
        Menu extraPages = new Menu(site, EXTRA_MENU_TITLE);
        extraPages.setOrder(Integer.valueOf(1));
        User author = Authenticate.getUser();
        Category summariesCategory = site.getOrCreateCategoryForSlug("summary", SUMMARIES_TITLE);
        Category announcementsCategory = site.getOrCreateCategoryForSlug("announcement", ANNOUNCEMENTS_TITLE);
        ListCategoryPosts summariesComponent = new ListCategoryPosts(summariesCategory);
        ListCategoryPosts announcementsComponent = new ListCategoryPosts(announcementsCategory);
        Component referencesComponent = Component.forType(BibliographicReferencesComponent.class);
        Component evaluationMethodsComponent = Component.forType(EvaluationMethodsComponent.class);
        Component homeComponent = Component.forType(InitialPageComponent.class);
        Page initialPage = Page.create((Site)site, (Menu)menu, null, (LocalizedString)INITIAL_PAGE_TITLE, (boolean)true, (String)"firstPage", (User)author, (Component[])new Component[]{homeComponent, announcementsComponent});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)GROUPS_TITLE, (boolean)true, (String)"groupings", (User)author, (Component[])new Component[]{Component.forType(GroupsComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)EVALUATIONS_TITLE, (boolean)true, (String)"evaluations", (User)author, (Component[])new Component[]{Component.forType(EvaluationsComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)REFERENCES_TITLE, (boolean)true, (String)"bibliographicReferences", (User)author, (Component[])new Component[]{referencesComponent});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)SCHEDULE_TITLE, (boolean)true, (String)"calendarEvents", (User)author, (Component[])new Component[]{Component.forType(ScheduleComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)EVALUATION_METHOD_TITLE, (boolean)true, (String)"evaluationMethods", (User)author, (Component[])new Component[]{evaluationMethodsComponent});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)OBJECTIVES_TITLE, (boolean)true, (String)"objectives", (User)author, (Component[])new Component[]{Component.forType(ObjectivesComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)LESSON_PLAN_TITLE, (boolean)true, (String)"lessonPlan", (User)author, (Component[])new Component[]{Component.forType(LessonPlanComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)PROGRAM_TITLE, (boolean)true, (String)"program", (User)author, (Component[])new Component[]{Component.forType(ObjectivesComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)SHIFTS_TITLE, (boolean)true, (String)"shifts", (User)author, (Component[])new Component[]{Component.forType(ExecutionCourseComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)ANNOUNCEMENTS_TITLE, (boolean)true, (String)"category", (User)author, (Component[])new Component[]{announcementsComponent});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)SUMMARIES_TITLE, (boolean)true, (String)"category", (User)author, (Component[])new Component[]{summariesComponent});
        Page.create((Site)site, null, null, (LocalizedString)VIEW_POST_TITLE, (boolean)true, (String)"view", (User)author, (Component[])new Component[]{Component.forType(ViewPost.class)});
        site.setInitialPage(initialPage);
        return site;
    }
}

