/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse.components;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.executionCourse.components.BaseExecutionCourseComponent;

@ComponentType(name="InitialPage", description="Provides the information needed for the initial page of an Execution Course")
public class InitialPageComponent
extends BaseExecutionCourseComponent {
    public static final int ANNOUNCEMENTS_TO_SHOW = 5;

    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        ExecutionCourse executionCourse = page.getSite().getExecutionCourse();
        globalContext.put((Object)"professorships", executionCourse.getProfessorshipsSet().stream().sorted(Comparator.comparing(Professorship::isResponsibleFor).reversed().thenComparing(Professorship.COMPARATOR_BY_PERSON_NAME)).collect(Collectors.toList()));
        globalContext.put((Object)"isStudent", (Object)this.isStudent(Authenticate.getUser()));
        globalContext.put((Object)"executionCourse", (Object)executionCourse);
        globalContext.put((Object)"previousExecutionCourses", this.previousExecutionCourses(executionCourse));
    }

    private List<ExecutionCourse> previousExecutionCourses(ExecutionCourse executionCourse) {
        return executionCourse.getAssociatedCurricularCoursesSet().stream().flatMap(c -> c.getAssociatedExecutionCoursesSet().stream()).distinct().filter(e -> !executionCourse.equals(e)).sorted(ExecutionCourse.EXECUTION_COURSE_EXECUTION_PERIOD_COMPARATOR.reversed()).collect(Collectors.toList());
    }

    private boolean isStudent(User user) {
        return user != null && user.getPerson() != null && user.getPerson().getStudent() != null;
    }
}

