/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.servlets;

import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.service.services.manager.MergeExecutionCourses;
import org.fenixedu.academic.service.services.teacher.PublishMarks;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.bennu.io.domain.GroupBasedFile;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.Menu;
import org.fenixedu.cms.domain.MenuItem;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.PostFile;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.component.StaticPost;
import org.fenixedu.cms.domain.component.StaticPost_Base;
import org.fenixedu.cms.routing.CMSRenderer;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.learning.FenixEduLearningConfiguration;
import org.fenixedu.learning.domain.degree.DegreeRequestHandler;
import org.fenixedu.learning.domain.degree.DegreeSiteListener;
import org.fenixedu.learning.domain.executionCourse.ExecutionCourseListener;
import org.fenixedu.learning.domain.executionCourse.ExecutionCourseRequestHandler;
import org.fenixedu.learning.domain.executionCourse.SummaryListener;
import org.fenixedu.learning.servlets.FenixEduLearningContextListener$PagesAdminService$callable$create;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@WebListener
public class FenixEduLearningContextListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(FenixEduLearningContextListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        if (!Boolean.TRUE.equals(FenixEduLearningConfiguration.getConfiguration().getDomainListenersEnabled())) {
            return;
        }
        Signal.register((String)"academic.summary.create.signal", event -> {
            Summary summary = (Summary)event.getInstance();
            SummaryListener.updatePost(new Post(summary.getExecutionCourse().getSite()), summary);
        });
        FenixFramework.getDomainModel().registerDeletionListener(Summary.class, summary -> {
            Post post = summary.getPost();
            if (post != null) {
                summary.setPost(null);
                post.delete();
            }
        });
        Signal.register((String)"academic.summary.edit.signal", event -> SummaryListener.updatePost(((Summary)event.getInstance()).getPost(), (Summary)event.getInstance()));
        Signal.register((String)"academic.executionCourse.create", event -> ExecutionCourseListener.create((ExecutionCourse)event.getInstance()));
        Signal.register((String)"academic.executionCourse.acronym.edit", event -> ExecutionCourseListener.updateSiteSlug((ExecutionCourse)event.getInstance()));
        Signal.register((String)"academic.degree.create", event -> DegreeSiteListener.create((Degree)event.getInstance()));
        Signal.register((String)"academic.PublishMarks.marks.published", FenixEduLearningContextListener::handleMarksPublishment);
        Signal.register((String)"fenixedu.cms.site.edited", FenixEduLearningContextListener::handleSiteEdition);
        FenixFramework.getDomainModel().registerDeletionListener(ExecutionCourse.class, executionCourse -> {
            if (executionCourse.getSite() != null) {
                Site site = executionCourse.getSite();
                executionCourse.setSite(null);
                site.delete();
            }
        });
        FenixFramework.getDomainModel().registerDeletionListener(Degree.class, degree -> {
            if (degree.getSite() != null) {
                Site site = degree.getSite();
                degree.setSite(null);
                site.delete();
            }
        });
        FenixFramework.getDomainModel().registerDeletionListener(Site.class, site -> {
            if (site.getSystemMenu() != null) {
                Menu menu = site.getSystemMenu();
                site.setSystemMenu(null);
            }
        });
        FenixFramework.getDomainModel().registerDeletionListener(Menu.class, menu -> {
            if (menu.getSystemSite() != null) {
                menu.setSystemSite(null);
            }
        });
        MergeExecutionCourses.registerMergeHandler(FenixEduLearningContextListener::copyExecutionCoursesSites);
        CMSRenderer.addHandler((CMSRenderer.RenderingPageHandler)new ExecutionCourseRequestHandler());
        CMSRenderer.addHandler((CMSRenderer.RenderingPageHandler)new DegreeRequestHandler());
    }

    private static void handleSiteEdition(DomainObjectEvent<Site> site) {
        if (((Site)site.getInstance()).getExecutionCourse() != null) {
            ((Site)site.getInstance()).getExecutionCourse().setSiteUrl(((Site)site.getInstance()).getFullUrl());
        }
    }

    private static void copyExecutionCoursesSites(ExecutionCourse from, ExecutionCourse to) {
        if (from.getSite() != null) {
            if (to.getSite() != null) {
                Menu newMenu = (Menu)to.getSite().getMenusSet().stream().findAny().get();
                LocalizedString newPageName = new LocalizedString().with(Locale.getDefault(), from.getName() + "(" + from.getDegreePresentationString() + ")");
                MenuItem emptyPageParent = PagesAdminService.create(to.getSite(), null, newPageName, new LocalizedString(), new LocalizedString()).get();
                emptyPageParent.getPage().setPublished(false);
                emptyPageParent.setTop(newMenu);
                for (Menu oldMenu : from.getSite().getMenusSet()) {
                    oldMenu.getToplevelItemsSorted().forEach(menuItem -> PagesAdminService.copyStaticPage(menuItem, to.getSite(), newMenu, emptyPageParent));
                }
            } else {
                to.setSite(from.getSite());
                from.setSite(null);
            }
        }
    }

    private static void handleMarksPublishment(PublishMarks.MarkPublishingBean bean) {
        Category cat;
        String publishmentMessage = bean.getEvaluation().getPublishmentMessage();
        if (publishmentMessage != null && !Strings.isNullOrEmpty((String)publishmentMessage.trim()) && bean.getCourse().getSite() != null && (cat = bean.getCourse().getSite().categoryForSlug("announcement")) != null) {
            Post post = new Post(bean.getCourse().getSite());
            post.addCategories(cat);
            post.setName(bean.getTitle() == null ? BundleUtil.getLocalizedString((String)"resources.ApplicationResources", (String)"message.publishment", (String[])new String[0]) : new LocalizedString(I18N.getLocale(), bean.getTitle()));
            post.setBody(new LocalizedString(I18N.getLocale(), bean.getEvaluation().getPublishmentMessage()));
            post.setActive(true);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    private static class PagesAdminService {
        public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

        private PagesAdminService() {
        }

        protected static Optional<MenuItem> create(Site site, MenuItem menuItem, LocalizedString localizedString, LocalizedString localizedString2, LocalizedString localizedString3) {
            return (Optional)advice$create.perform((Callable)new FenixEduLearningContextListener$PagesAdminService$callable$create(site, menuItem, localizedString, localizedString2, localizedString3));
        }

        protected static /* synthetic */ Optional<MenuItem> advised$create(Site site, MenuItem parent, LocalizedString name, LocalizedString body, LocalizedString excerpt) {
            Menu menu = site.getMenusSet().stream().findFirst().orElse(null);
            Page page = Page.create((Site)site, (Menu)menu, (MenuItem)parent, (LocalizedString)Post.sanitize((LocalizedString)name), (boolean)true, (String)"view", (User)Authenticate.getUser(), (Component[])new Component[0]);
            Category category = site.getOrCreateCategoryForSlug("content", new LocalizedString().with(I18N.getLocale(), "Content"));
            Post post = Post.create((Site)site, (Page)page, (LocalizedString)Post.sanitize((LocalizedString)name), (LocalizedString)Post.sanitize((LocalizedString)body), (LocalizedString)Post.sanitize((LocalizedString)excerpt), (Category)category, (boolean)true, (User)Authenticate.getUser());
            page.addComponents((Component)new StaticPost(post));
            MenuItem menuItem = (MenuItem)page.getMenuItemsSet().stream().findFirst().get();
            if (parent != null) {
                parent.add(menuItem);
            } else {
                menu.add(menuItem);
            }
            return Optional.of(menuItem);
        }

        protected static void copyStaticPage(MenuItem oldMenuItem, Site newSite, Menu newMenu, MenuItem newParent) {
            if (oldMenuItem.getPage() != null) {
                Page oldPage = oldMenuItem.getPage();
                PagesAdminService.staticPost(oldPage).ifPresent(oldPost -> {
                    Page newPage = new Page(newSite, oldPage.getName());
                    newPage.setTemplate(newSite.getTheme().templateForType(oldPage.getTemplate().getType()));
                    newPage.setCreatedBy(Authenticate.getUser());
                    newPage.setPublished(false);
                    for (Component component : oldPage.getComponentsSet()) {
                        if (!(component instanceof StaticPost)) continue;
                        StaticPost staticPostComponent = (StaticPost)component;
                        Post newPost = PagesAdminService.clonePost(staticPostComponent.getPost(), newSite);
                        newPost.setActive(true);
                        StaticPost newComponent = new StaticPost(newPost);
                        newPage.addComponents((Component)newComponent);
                    }
                    MenuItem newMenuItem = MenuItem.create((Menu)newMenu, (Page)newPage, (LocalizedString)oldMenuItem.getName(), (MenuItem)newParent);
                    newMenuItem.setPosition(oldMenuItem.getPosition());
                    newMenuItem.setUrl(oldMenuItem.getUrl());
                    newMenuItem.setFolder(oldMenuItem.getFolder());
                    oldMenuItem.getChildrenSet().stream().forEach(child -> PagesAdminService.copyStaticPage(child, newSite, newMenu, newMenuItem));
                });
            }
        }

        private static Post clonePost(Post oldPost, Site newSite) {
            Post newPost = new Post(newSite);
            newPost.setName(oldPost.getName());
            newPost.setBodyAndExcerpt(oldPost.getBody(), oldPost.getExcerpt());
            newPost.setCreationDate(new DateTime());
            newPost.setCreatedBy(Authenticate.getUser());
            newPost.setActive(oldPost.getActive());
            for (Category oldCategory : oldPost.getCategoriesSet()) {
                Category newCategory = newSite.getOrCreateCategoryForSlug(oldCategory.getSlug(), oldCategory.getName());
                newPost.addCategories(newCategory);
            }
            oldPost.getFilesSet().stream().map(postFile -> postFile.getFiles()).forEach(file -> {
                try {
                    new PostFile(newPost, new GroupBasedFile(file.getDisplayName(), file.getFilename(), file.getStream(), Group.anyone()), false, file.getPostFile().getIndex().intValue());
                }
                catch (IOException e) {
                    logger.warn("could not clone file " + file.getDisplayName() + " from post " + newPost.getSlug() + " on site " + newPost.getSite().getSlug());
                }
            });
            return newPost;
        }

        private static Optional<Post> staticPost(Page page) {
            return page.getComponentsSet().stream().filter(StaticPost.class::isInstance).map(StaticPost.class::cast).map(StaticPost_Base::getPost).findFirst();
        }
    }
}

