/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.degree.components;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.degree.components.DegreeSiteComponent;
import pt.ist.fenixframework.FenixFramework;

@ComponentType(name="Curricular Course", description="Curricular course info")
public class CurricularCourseComponent
extends DegreeSiteComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        CurricularCourse curricularCourse = (CurricularCourse)FenixFramework.getDomainObject((String)globalContext.getRequestContext()[1]);
        ExecutionInterval period = this.getExecutionSemester(curricularCourse, globalContext.getRequestContext());
        globalContext.put((Object)"curricularCourse", this.createWrap(curricularCourse, period));
    }

    private ExecutionInterval getExecutionSemester(CurricularCourse curricularCourse, String[] request) {
        return request.length > 2 ? (ExecutionInterval)FenixFramework.getDomainObject((String)request[2]) : curricularCourse.getParentDegreeCurricularPlan().getMostRecentExecutionYear().getLastExecutionPeriod();
    }

    private HashMap<String, Object> createWrap(CurricularCourse curricularCourse, ExecutionInterval period) {
        HashMap wrap = Maps.newHashMap();
        wrap.put("period", period);
        wrap.put("name", curricularCourse.getNameI18N(period));
        wrap.put("degreeCurricularPlanName", curricularCourse.getDegreeCurricularPlan().getPresentationName());
        wrap.put("acronym", curricularCourse.getAcronym(period));
        wrap.put("isOptional", curricularCourse.isOptionalCurricularCourse());
        wrap.put("executionCourses", curricularCourse.getAssociatedExecutionCoursesSet().stream().sorted(ExecutionCourse.EXECUTION_COURSE_EXECUTION_PERIOD_COMPARATOR.reversed()).map(ec -> this.createWrap((ExecutionCourse)ec)).collect(Collectors.toList()));
        wrap.put("parentContexts", curricularCourse.getParentContextsByExecutionYear(period.getExecutionYear()));
        wrap.put("weight", curricularCourse.getWeight(period));
        wrap.put("objectives", curricularCourse.getObjectivesI18N(period));
        wrap.put("program", curricularCourse.getProgramI18N(period));
        wrap.put("evaluationMethod", curricularCourse.getEvaluationMethodI18N(period));
        return wrap;
    }

    private Map<String, Object> createWrap(ExecutionCourse executionCourse) {
        HashMap wrap = Maps.newHashMap();
        wrap.put("name", executionCourse.getNameI18N());
        wrap.put("executionYear", executionCourse.getExecutionYear().getYear());
        wrap.put("executionPeriod", executionCourse.getExecutionPeriod().getName());
        wrap.put("url", executionCourse.getSite() != null ? executionCourse.getSite().getFullUrl() : "#");
        return wrap;
    }
}

