/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse.components;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Mark;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.executionCourse.components.BaseExecutionCourseComponent;

@ComponentType(name="Marks", description="Marks for an Execution Course")
public class MarksComponent
extends BaseExecutionCourseComponent {
    private static final Comparator<Evaluation> EVALUATION_COMPARATOR = new Comparator<Evaluation>(){

        @Override
        public int compare(Evaluation evaluation1, Evaluation evaluation2) {
            String evaluation1ComparisonString = this.evaluationComparisonString(evaluation1);
            String evaluation2ComparisonString = this.evaluationComparisonString(evaluation2);
            return evaluation1ComparisonString.compareTo(evaluation2ComparisonString);
        }

        private String evaluationComparisonString(Evaluation evaluation) {
            return evaluation.getEvaluationDate() != null ? new SimpleDateFormat("yyyy/MM/dd").format(evaluation.getEvaluationDate()) + evaluation.getExternalId() : evaluation.getExternalId();
        }
    };

    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        ExecutionCourse executionCourse = page.getSite().getExecutionCourse();
        Map<Attends, Map<Evaluation, Mark>> attendsMap = this.attendsMap(executionCourse);
        globalContext.put((Object)"attendsMap", attendsMap);
        globalContext.put((Object)"numberOfStudents", (Object)attendsMap.size());
        globalContext.put((Object)"dont-cache-pages-in-search-engines", (Object)Boolean.TRUE);
        globalContext.put((Object)"evaluations", (Object)executionCourse.getAssociatedEvaluationsSet());
    }

    private Map<Attends, Map<Evaluation, Mark>> attendsMap(ExecutionCourse executionCourse) {
        TreeMap<Attends, Map<Evaluation, Mark>> attendsMap = new TreeMap<Attends, Map<Evaluation, Mark>>(Attends.COMPARATOR_BY_STUDENT_NUMBER);
        for (Attends attends : executionCourse.getAttendsSet()) {
            TreeMap<Evaluation, Mark> evaluationsMap = new TreeMap<Evaluation, Mark>(EVALUATION_COMPARATOR);
            attendsMap.put(attends, evaluationsMap);
            for (Evaluation evaluation : executionCourse.getAssociatedEvaluationsSet()) {
                if (evaluation.getPublishmentMessage() == null) continue;
                evaluationsMap.put(evaluation, null);
            }
            for (Mark mark : attends.getAssociatedMarksSet()) {
                if (mark.getEvaluation().getPublishmentMessage() == null) continue;
                evaluationsMap.put(mark.getEvaluation(), mark);
            }
        }
        return attendsMap;
    }
}

