/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.degree.components;

import java.util.Comparator;
import java.util.stream.Collectors;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.degree.components.DegreeSiteComponent;
import org.joda.time.ReadableInstant;

@ComponentType(name="latestAnnouncements", description="Latest Announcements of a Degree")
public class LatestAnnouncementsComponent
extends DegreeSiteComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext global) {
        Category announcements = page.getSite().getCategoriesSet().stream().filter(c -> c.getSlug().equals("announcement")).findAny().orElse(null);
        if (announcements != null) {
            global.put((Object)"announcements", announcements.getPostsSet().stream().sorted(new Comparator<Post>(){

                @Override
                public int compare(Post a, Post b) {
                    return a.getModificationDate().compareTo((ReadableInstant)b.getModificationDate());
                }
            }).limit(3L).map(p -> p.makeWrap()).collect(Collectors.toList()));
            global.put((Object)"announcementsPage", (Object)announcements.getAddress());
        }
    }
}

