/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.degree.components;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.Degree_Base;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.DegreeCurricularPlanServices;
import org.fenixedu.learning.domain.degree.components.DegreeSiteComponent;
import org.fenixedu.spaces.domain.Space;
import pt.ist.fenixframework.FenixFramework;

@ComponentType(name="degreeDescription", description="Description of a Degree")
public class DescriptionComponent
extends DegreeSiteComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext global) {
        Degree degree = this.degree(page);
        global.put((Object)"degreeName", (Object)degree.getPresentationName());
        ExecutionYear targetExecutionYear = this.getTargetExecutionYear(global, degree);
        global.put((Object)"year", (Object)targetExecutionYear.getYear());
        String campusName = Optional.ofNullable(degree).map(Degree_Base::getUnit).map(Unit::getCampus).map(Space::getName).orElse("");
        global.put((Object)"campi", (Object)campusName);
        Collection<Teacher> responsibleCoordinatorsTeachers = DescriptionComponent.getResponsibleCoordinatorsTeachers(degree, targetExecutionYear);
        if (responsibleCoordinatorsTeachers.isEmpty()) {
            responsibleCoordinatorsTeachers = DescriptionComponent.getCurrentResponsibleCoordinatorsTeachers(degree);
        }
        global.put((Object)"coordinators", responsibleCoordinatorsTeachers);
        DegreeInfo degreeInfo = degree.getDegreeInfoFor(targetExecutionYear);
        if (degreeInfo == null) {
            degreeInfo = degree.getMostRecentDegreeInfo(targetExecutionYear.getAcademicInterval());
        }
        global.put((Object)"degreeInfo", (Object)degreeInfo);
    }

    private static Collection<Teacher> getResponsibleCoordinatorsTeachers(Degree degree, ExecutionYear executionYear) {
        return Coordinator.findCoordinators((Degree)degree, (ExecutionYear)executionYear, (boolean)true).map(c -> c.getPerson().getTeacher()).filter(Objects::nonNull).distinct().sorted(Teacher.TEACHER_COMPARATOR_BY_CATEGORY_AND_NUMBER).collect(Collectors.toUnmodifiableList());
    }

    private static Collection<Teacher> getCurrentResponsibleCoordinatorsTeachers(Degree degree) {
        return Coordinator.findLastCoordinators((Degree)degree, (boolean)true).map(c -> c.getPerson().getTeacher()).filter(Objects::nonNull).distinct().sorted(Teacher.TEACHER_COMPARATOR_BY_CATEGORY_AND_NUMBER).collect(Collectors.toUnmodifiableList());
    }

    private ExecutionYear getTargetExecutionYear(TemplateContext global, Degree degree) {
        String executionDegreeId = global.getParameter("executionDegreeID");
        if (executionDegreeId != null) {
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeId);
            if (executionDegree == null || !executionDegree.getDegreeCurricularPlan().getDegree().equals((Object)degree)) {
                throw new RuntimeException("Unknown Execution Degree identifier.");
            }
            return executionDegree.getExecutionYear();
        }
        DegreeInfo latest = degree.getDegreeInfosSet().stream().max(DegreeInfo.COMPARATOR_BY_EXECUTION_YEAR).orElse(null);
        if (latest != null) {
            return latest.getExecutionYear();
        }
        ExecutionYear current = ExecutionYear.readCurrentExecutionYear();
        Set<ExecutionYear> years = DegreeCurricularPlanServices.getDegreeCurricularPlansExecutionYears(degree);
        if (years.isEmpty() || years.contains(current)) {
            return current;
        }
        ExecutionYear first = years.stream().min(ExecutionYear::compareTo).orElse(null);
        ExecutionYear last = years.stream().max(ExecutionYear::compareTo).orElse(null);
        return current.isBefore(first) ? first : last;
    }
}

