/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse;

import com.google.common.base.Joiner;
import java.util.Objects;
import java.util.Optional;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.cms.domain.Role;
import org.fenixedu.cms.domain.RoleTemplate;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.learning.domain.executionCourse.ExecutionCourseSiteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionCourseListener {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionCourseListener.class);

    public static Site create(ExecutionCourse executionCourse) {
        Site newSite = ExecutionCourseSiteBuilder.getInstance().create(executionCourse.getNameI18N(), ExecutionCourseListener.getObjectives(executionCourse).orElseGet(() -> executionCourse.getNameI18N()), ExecutionCourseListener.formatSlugForExecutionCourse(executionCourse));
        executionCourse.setSite(newSite);
        RoleTemplate defaultTemplate = newSite.getDefaultRoleTemplate();
        if (defaultTemplate == null) {
            throw new DomainException("no.default.role", new String[0]);
        }
        Role teacherRole = new Role(defaultTemplate, executionCourse.getSite());
        Group group = teacherRole.getGroup();
        teacherRole.setGroup(group);
        logger.info("Created site for execution course " + executionCourse.getSigla());
        return newSite;
    }

    private static Optional<LocalizedString> getObjectives(ExecutionCourse executionCourse) {
        return executionCourse.getCompetenceCourses().stream().map(competenceCourse -> competenceCourse.getObjectivesI18N(executionCourse.getExecutionPeriod())).filter(Objects::nonNull).findFirst();
    }

    private static String formatSlugForExecutionCourse(ExecutionCourse executionCourse) {
        return Joiner.on((String)"-").join((Object)executionCourse.getSigla(), (Object)executionCourse.getExternalId(), new Object[0]);
    }

    public static void updateSiteSlug(ExecutionCourse instance) {
        instance.getSite().setSlug(ExecutionCourseListener.formatSlugForExecutionCourse(instance));
        instance.setSiteUrl(instance.getSite().getFullUrl());
    }
}

