/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.commons.i18n.LocalizedString;

public class CompetenceCourseBean {
    private final CompetenceCourse competenceCourse;
    private final ExecutionInterval executionInterval;
    private final Set<CurricularCourse> curricularCourses;
    private final LocalizedString name;
    private final LocalizedString objectives;
    private final LocalizedString program;

    public CompetenceCourseBean(CompetenceCourse competenceCourse, Set<CurricularCourse> curricularCourses, ExecutionInterval executionInterval) {
        this.competenceCourse = competenceCourse;
        this.executionInterval = executionInterval;
        this.curricularCourses = curricularCourses;
        this.name = competenceCourse.getNameI18N(executionInterval);
        this.objectives = competenceCourse.getObjectivesI18N(executionInterval);
        this.program = competenceCourse.getProgramI18N(executionInterval);
    }

    public CompetenceCourse getCompetenceCourse() {
        return this.competenceCourse;
    }

    @Deprecated
    public ExecutionInterval getExecutionSemester() {
        return this.getExecutionInterval();
    }

    public ExecutionInterval getExecutionInterval() {
        return this.executionInterval;
    }

    public Set<CurricularCourse> getCurricularCourses() {
        return this.curricularCourses;
    }

    public LocalizedString getName() {
        return this.name;
    }

    public LocalizedString getObjectives() {
        return this.objectives;
    }

    public static List<CompetenceCourseBean> approvedCompetenceCourses(ExecutionCourse executionCourse) {
        return CompetenceCourseBean.getCurricularCoursesIndexedByCompetenceCourse(executionCourse).entrySet().stream().filter(entry -> ((CompetenceCourse)entry.getKey()).isApproved()).map(entry -> new CompetenceCourseBean((CompetenceCourse)entry.getKey(), (Set)entry.getValue(), executionCourse.getExecutionPeriod())).collect(Collectors.toList());
    }

    private static Map<CompetenceCourse, Set<CurricularCourse>> getCurricularCoursesIndexedByCompetenceCourse(ExecutionCourse executionCourse) {
        HashMap<CompetenceCourse, Set<CurricularCourse>> curricularCourseMap = new HashMap<CompetenceCourse, Set<CurricularCourse>>();
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            TreeSet<CurricularCourse> curricularCourses;
            CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
            if (competenceCourse == null) continue;
            if (curricularCourseMap.containsKey(competenceCourse)) {
                curricularCourses = (TreeSet<CurricularCourse>)curricularCourseMap.get(competenceCourse);
            } else {
                curricularCourses = new TreeSet<CurricularCourse>(CurricularCourse.CURRICULAR_COURSE_COMPARATOR_BY_DEGREE_AND_NAME);
                curricularCourseMap.put(competenceCourse, curricularCourses);
            }
            curricularCourses.add(curricularCourse);
        }
        return curricularCourseMap;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("objectives", (Object)this.objectives).add("executionInterval", (Object)this.executionInterval).add("curricularCourses", this.curricularCourses).toString();
    }

    public LocalizedString getProgram() {
        return this.program;
    }
}

