/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet.styles;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.fenixedu.commons.spreadsheet.styles.CellStyle;

public class FontWeight
extends CellStyle {
    static final short BOLDWEIGHT_BOLD = 700;
    private final boolean boldweight;

    public FontWeight(short boldweight) {
        this.boldweight = boldweight == 700;
    }

    public FontWeight(boolean isBold) {
        this.boldweight = isBold;
    }

    @Override
    protected void appendToStyle(HSSFWorkbook book, HSSFCellStyle style, HSSFFont font) {
        font.setBold(this.boldweight);
    }

    @Override
    public HSSFCellStyle getStyle(HSSFWorkbook book) {
        HSSFCellStyle style = book.createCellStyle();
        HSSFFont font = book.createFont();
        this.appendToStyle(book, style, font);
        style.setFont(font);
        return style;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FontWeight) {
            FontWeight fontWeight = (FontWeight)obj;
            return this.boldweight == fontWeight.boldweight;
        }
        return false;
    }

    public int hashCode() {
        return this.boldweight ? 700 : Boolean.hashCode(this.boldweight);
    }
}

