/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet.styles;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.fenixedu.commons.spreadsheet.styles.CellStyle;

public class ComposedCellStyle
extends CellStyle {
    private final List<CellStyle> parts = new ArrayList<CellStyle>();

    @Override
    public HSSFCellStyle getStyle(HSSFWorkbook book) {
        HSSFCellStyle style = book.createCellStyle();
        HSSFFont font = book.createFont();
        for (CellStyle part : this.parts) {
            part.appendToStyle(book, style, font);
        }
        style.setFont(font);
        return style;
    }

    @Override
    protected void appendToStyle(HSSFWorkbook book, HSSFCellStyle style, HSSFFont font) {
    }

    public CellStyle merge(CellStyle style) {
        this.parts.add(style);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComposedCellStyle) {
            ComposedCellStyle composedCellStyle = (ComposedCellStyle)obj;
            boolean equals = true;
            for (int i = 0; i < this.parts.size(); ++i) {
                if (this.parts.get(i).equals(composedCellStyle.parts.get(i))) continue;
                equals = false;
                break;
            }
            return equals;
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        for (CellStyle part : this.parts) {
            result += part.hashCode();
        }
        return result;
    }
}

