/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.fenixedu.commons.spreadsheet.ExcelStyle;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

public class SpreadsheetXLSExporter {
    public void exportToXLSSheet(Spreadsheet spreadsheet, OutputStream outputStream) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        ExcelStyle excelStyle = new ExcelStyle(workbook);
        this.exportToXLSSheet(workbook, spreadsheet, excelStyle.getHeaderStyle(), excelStyle.getStringStyle());
        workbook.write(outputStream);
    }

    public void exportToXLSSheet(Spreadsheet spreadsheet, File file) throws IOException {
        FilterOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.exportToXLSSheet(spreadsheet, outputStream);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void exportToXLSSheets(OutputStream outputStream, Spreadsheet ... spreadsheets) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        ExcelStyle excelStyle = new ExcelStyle(workbook);
        for (Spreadsheet spreadsheet : spreadsheets) {
            this.exportToXLSSheet(workbook, spreadsheet, excelStyle.getHeaderStyle(), excelStyle.getStringStyle());
        }
        workbook.write(outputStream);
    }

    public void exportToXLSSheets(OutputStream outputStream, List<Spreadsheet> spreadsheets) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        ExcelStyle excelStyle = new ExcelStyle(workbook);
        for (Spreadsheet spreadsheet : spreadsheets) {
            this.exportToXLSSheet(workbook, spreadsheet, excelStyle.getHeaderStyle(), excelStyle.getStringStyle());
        }
        workbook.write(outputStream);
    }

    public void exportToXLSSheet(HSSFWorkbook workbook, Spreadsheet spreadsheet, HSSFCellStyle headerCellStyle, HSSFCellStyle cellStyle) {
        HSSFSheet sheet = workbook.createSheet(spreadsheet.getName());
        sheet.setDefaultColumnWidth(20);
        this.exportXLSHeaderLine(sheet, headerCellStyle, spreadsheet.getHeader());
        for (Spreadsheet.Row row : spreadsheet.getRows()) {
            this.exportXLSRowLine(sheet, cellStyle, row.getCells());
        }
        Spreadsheet next = spreadsheet.getNextSpreadsheet();
        if (next != null) {
            this.exportToXLSSheet(workbook, next, headerCellStyle, cellStyle);
        }
    }

    protected void exportXLSHeaderLine(HSSFSheet sheet, HSSFCellStyle cellStyle, List<Object> cells) {
        this.exportXLSLine(sheet, cellStyle, cells, 0);
    }

    protected void exportXLSRowLine(HSSFSheet sheet, HSSFCellStyle cellStyle, List<Object> cells) {
        this.exportXLSLine(sheet, cellStyle, cells, 1);
    }

    protected void exportXLSLine(HSSFSheet sheet, HSSFCellStyle cellStyle, List<Object> cells, int offset) {
        HSSFRow row = sheet.createRow(sheet.getLastRowNum() + offset);
        for (Object cellValue : cells) {
            this.addColumn(cellStyle, row, cellValue);
        }
    }

    protected HSSFCell addColumn(HSSFCellStyle cellStyle, HSSFRow row, Object cellValue) {
        HSSFCell cell = row.createCell((int)(row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum()));
        cell.setCellStyle(cellStyle);
        if (cellValue != null) {
            cell.setCellValue(cellValue.toString());
        } else {
            cell.setCellValue("");
        }
        return cell;
    }
}

