/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fenixedu.commons.spreadsheet.CsvBuilder;
import org.fenixedu.commons.spreadsheet.ExcelBuilder;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;
import org.fenixedu.commons.spreadsheet.converters.CellConverter;
import org.fenixedu.commons.spreadsheet.styles.CellStyle;

public class SpreadsheetBuilder {
    private Map<String, SheetData<?>> sheets = new HashMap();
    private final Map<Class<?>, CellConverter> converters = new HashMap();
    private CellStyle headerStyle = null;
    private CellStyle mergeHeaderStyle = null;
    private final Map<Class<?>, CellStyle> typeStyles = new HashMap();
    private List<CellStyle> rowStyles = new ArrayList<CellStyle>();

    public SpreadsheetBuilder addSheet(String name, SheetData<?> sheet) {
        this.sheets.put(name, sheet);
        return this;
    }

    public SpreadsheetBuilder addConverter(Class<?> type, CellConverter converter) {
        this.converters.put(type, converter);
        return this;
    }

    public SpreadsheetBuilder setHeaderStyle(CellStyle style) {
        this.headerStyle = style;
        return this;
    }

    protected SpreadsheetBuilder appendHeaderStyle(CellStyle style) {
        this.mergeHeaderStyle = style;
        return this;
    }

    protected SpreadsheetBuilder addTypeStyle(Class<?> type, CellStyle style) {
        this.typeStyles.put(type, style);
        return this;
    }

    protected SpreadsheetBuilder setRowStyle(CellStyle ... styles) {
        this.rowStyles = Arrays.asList(styles);
        return this;
    }

    public void build(WorkbookExportFormat format, String filename) throws IOException {
        this.build(format, new File(filename));
    }

    public void build(WorkbookExportFormat format, File file) throws IOException {
        this.build(format, new FileOutputStream(file));
    }

    public void build(WorkbookExportFormat format, OutputStream output) throws IOException {
        switch (format) {
            case EXCEL: {
                ExcelBuilder builder = new ExcelBuilder();
                for (Map.Entry<Class<?>, CellConverter> entry : this.converters.entrySet()) {
                    builder.addConverter(entry.getKey(), entry.getValue());
                }
                if (this.headerStyle != null) {
                    builder.setHeaderStyle(this.headerStyle);
                }
                if (this.mergeHeaderStyle != null) {
                    builder.appendHeaderStyle(this.mergeHeaderStyle);
                }
                for (Map.Entry<Class<?>, Object> entry : this.typeStyles.entrySet()) {
                    builder.addTypeStyle(entry.getKey(), (CellStyle)entry.getValue());
                }
                builder.setRowStyle(this.rowStyles.toArray(new CellStyle[0]));
                builder.build(this.sheets, output);
                break;
            }
            case CSV: 
            case TSV: {
                CsvBuilder builder = new CsvBuilder();
                for (Map.Entry<Class<?>, CellConverter> entry : this.converters.entrySet()) {
                    builder.addConverter(entry.getKey(), entry.getValue());
                }
                builder.build(this.sheets, output, format.getSeparator());
                break;
            }
        }
    }
}

