/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.commons.spreadsheet.AbstractSheetBuilder;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.converters.CellConverter;
import org.fenixedu.commons.spreadsheet.converters.LocalizedStringCellConverter;
import org.fenixedu.commons.spreadsheet.converters.csv.BigDecimalCellConverter;
import org.fenixedu.commons.spreadsheet.converters.csv.CalendarCellConverter;
import org.fenixedu.commons.spreadsheet.converters.csv.DateCellConverter;
import org.fenixedu.commons.spreadsheet.converters.csv.DateTimeCellConverter;
import org.fenixedu.commons.spreadsheet.converters.csv.LocalDateCellConverter;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

class CsvBuilder
extends AbstractSheetBuilder {
    static Map<Class<?>, CellConverter> BASE_CONVERTERS = new HashMap();

    CsvBuilder() {
        this.converters.putAll(BASE_CONVERTERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(Map<String, SheetData<?>> sheets, OutputStream output, String separator) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        try {
            ArrayList<String> lines = new ArrayList<String>();
            for (SheetData<?> data : sheets.values()) {
                ArrayList<String> column;
                if (!data.headers.get(0).isEmpty()) {
                    for (List<SheetData.Cell> headerRow : data.headers) {
                        column = new ArrayList<String>();
                        for (SheetData.Cell cell : headerRow) {
                            column.add(cell.value.toString());
                            if (cell.span <= 1) continue;
                            column.addAll(Arrays.asList(new String[cell.span - 1]));
                        }
                        lines.add(String.join((CharSequence)separator, column));
                    }
                }
                for (List<SheetData.Cell> line : data.matrix) {
                    column = new ArrayList();
                    for (SheetData.Cell cell : line) {
                        column.add(cell.value != null ? this.convert(cell.value).toString().replace(separator, " ") : "");
                        if (cell.span <= 1) continue;
                        column.addAll(Arrays.asList(new String[cell.span - 1]));
                    }
                    lines.add(String.join((CharSequence)separator, column));
                }
            }
            writer.write(String.join((CharSequence)"\n", lines));
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    static {
        BASE_CONVERTERS.put(DateTime.class, new DateTimeCellConverter());
        BASE_CONVERTERS.put(LocalDate.class, new LocalDateCellConverter());
        BASE_CONVERTERS.put(GregorianCalendar.class, new CalendarCellConverter());
        BASE_CONVERTERS.put(Date.class, new DateCellConverter());
        BASE_CONVERTERS.put(BigDecimal.class, new BigDecimalCellConverter());
        BASE_CONVERTERS.put(LocalizedString.class, new LocalizedStringCellConverter());
    }
}

