/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.i18n;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.text.Collator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalizedString
implements Serializable,
Comparable<LocalizedString> {
    private static final long serialVersionUID = -31967064113338779L;
    protected static final Logger logger = LoggerFactory.getLogger(LocalizedString.class);
    protected final InternalMap map;

    public LocalizedString() {
        this.map = new InternalMap();
    }

    public LocalizedString(Locale locale, String content) {
        this.map = new Builder().with((Locale)locale, (String)content).map;
    }

    protected LocalizedString(InternalMap map) {
        this.map = map;
    }

    public Builder builder() {
        return new Builder((InternalMap)this.map.clone());
    }

    public LocalizedString with(Locale locale, String content) {
        return this.builder().with(locale, content).build();
    }

    public LocalizedString without(Locale locale) {
        return this.builder().without(locale).build();
    }

    public LocalizedString append(LocalizedString string) {
        return this.builder().append(string).build();
    }

    public LocalizedString append(LocalizedString string, String separator) {
        return this.builder().append(string, separator).build();
    }

    public LocalizedString append(String string) {
        return this.builder().append(string).build();
    }

    public LocalizedString append(String string, String separator) {
        return this.builder().append(string, separator).build();
    }

    public Set<Locale> getLocales() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public void forEach(BiConsumer<Locale, String> action) {
        Objects.requireNonNull(action);
        for (Map.Entry entry : this.map.entrySet()) {
            action.accept((Locale)entry.getKey(), (String)entry.getValue());
        }
    }

    public boolean anyMatch(Predicate<String> predicate) {
        return this.map.values().stream().anyMatch(predicate);
    }

    public String getOrDefault(Locale locale, String defaultValue) {
        String value = this.getContent(locale);
        return value == null ? defaultValue : value;
    }

    public LocalizedString map(Function<String, String> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Builder builder = this.builder();
        for (Map.Entry entry : this.map.entrySet()) {
            builder.with((Locale)entry.getKey(), mappingFunction.apply((String)entry.getValue()));
        }
        return builder.build();
    }

    public String getContent(Locale locale) {
        return this.getContent(locale, true);
    }

    public String getContent(Locale locale, boolean lookForAlternative) {
        return this.map.getContent(locale, lookForAlternative);
    }

    public String getContent() {
        String text = this.getContent(I18N.getLocale());
        if (text == null) {
            text = this.getContent(Locale.getDefault());
        }
        if (text == null && !this.map.isEmpty()) {
            text = (String)this.map.values().iterator().next();
        }
        return text;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public JsonElement json() {
        return this.map.json();
    }

    public static LocalizedString fromJson(JsonElement json) {
        return InternalMap.fromJson(json);
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public int compareTo(LocalizedString other) {
        return Collator.getInstance(I18N.getLocale()).compare(this.isEmpty() ? "" : this.getContent(), other.isEmpty() ? "" : other.getContent());
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalizedString) {
            LocalizedString i18NString = (LocalizedString)obj;
            return this.map.equals(i18NString.map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    protected static final class InternalMap
    extends HashMap<Locale, String> {
        private static final long serialVersionUID = -2722162618911116061L;

        protected InternalMap() {
        }

        public String getContent(Locale locale, boolean lookForAlternative) {
            if (this.containsKey(locale)) {
                return (String)this.get(locale);
            }
            if (!lookForAlternative) {
                return "";
            }
            Locale generic = this.generifyLocale(locale);
            while (generic != null) {
                if (this.containsKey(generic)) {
                    return (String)this.get(generic);
                }
                generic = this.generifyLocale(generic);
            }
            HashSet<Locale> sameLanguage = new HashSet<Locale>();
            for (Locale candidate : this.keySet()) {
                if (!candidate.getLanguage().equals(locale.getLanguage())) continue;
                sameLanguage.add(candidate);
            }
            if (!sameLanguage.isEmpty()) {
                if (sameLanguage.size() == 1) {
                    return (String)this.get(sameLanguage.iterator().next());
                }
                HashSet<Locale> sameCountry = new HashSet<Locale>();
                for (Locale candidate : sameLanguage) {
                    if (!candidate.getCountry().equals(locale.getCountry())) continue;
                    sameCountry.add(locale);
                }
                if (!sameCountry.isEmpty()) {
                    if (sameCountry.size() == 1) {
                        return (String)this.get(sameCountry.iterator().next());
                    }
                    logger.debug("Retrieving a content with ambiguous locale fallback strategy");
                    return (String)this.get(sameLanguage.iterator().next());
                }
                logger.debug("Retrieving a content with ambiguous locale fallback strategy");
                return (String)this.get(sameLanguage.iterator().next());
            }
            if (!locale.equals(I18N.getLocale())) {
                return this.getContent(I18N.getLocale());
            }
            return null;
        }

        public String getContent(Locale locale) {
            return this.getContent(locale, true);
        }

        private Locale generifyLocale(Locale locale) {
            if (Strings.isNullOrEmpty((String)locale.getVariant())) {
                if (Strings.isNullOrEmpty((String)locale.getCountry())) {
                    return null;
                }
                return new Locale(locale.getLanguage());
            }
            return new Locale(locale.getLanguage(), locale.getCountry());
        }

        public JsonElement json() {
            JsonObject json = new JsonObject();
            for (Locale locale : this.keySet()) {
                json.addProperty(locale.toLanguageTag(), (String)this.get(locale));
            }
            return json;
        }

        public static LocalizedString fromJson(JsonElement json) {
            Builder builder = new Builder();
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                Locale locale = new Locale.Builder().setLanguageTag((String)entry.getKey()).build();
                builder = builder.with(locale, ((JsonElement)entry.getValue()).getAsString());
            }
            return builder.build();
        }
    }

    public static final class Builder {
        protected InternalMap map;

        public Builder() {
            this.map = new InternalMap();
        }

        protected Builder(InternalMap map) {
            this.map = map;
        }

        public Builder with(Locale locale, String content) {
            if (locale == null) {
                throw new RuntimeException("Attempted adding null locale to LocalizedString");
            }
            if (Strings.isNullOrEmpty((String)content)) {
                logger.debug("adding null content for locale: {} to {}", (Object)locale.toLanguageTag(), (Object)this.toString());
                return this;
            }
            this.map.put(locale, content);
            return this;
        }

        public Builder without(Locale locale) {
            this.map.remove(locale);
            return this;
        }

        public Builder append(LocalizedString string) {
            return this.append(string, "");
        }

        public Builder append(LocalizedString string, String separator) {
            Stream.concat(this.map.keySet().stream(), string.map.keySet().stream()).distinct().forEach(locale -> this.map.put(locale, Joiner.on((String)separator).skipNulls().join(this.map.get(locale), string.map.get(locale), new Object[0])));
            return this;
        }

        public Builder append(String string) {
            return this.append(string, "");
        }

        public Builder append(String string, String separator) {
            for (Locale locale : this.map.keySet()) {
                this.map.put(locale, Joiner.on((String)separator).skipNulls().join(this.map.get(locale), (Object)string, new Object[0]));
            }
            return this;
        }

        public LocalizedString build() {
            return new LocalizedString(this.map);
        }
    }
}

