/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons;

import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Pattern;

public class StringNormalizer {
    private static final Pattern NONLATIN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");

    public static String normalizeAndRemoveAccents(String text) {
        return Normalizer.normalize(text, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static String normalizePreservingCapitalizedLetters(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }

    public static String normalize(String string) {
        return StringNormalizer.normalizePreservingCapitalizedLetters(string).toLowerCase();
    }

    public static String slugify(String name) {
        String result = StringNormalizer.normalizePreservingCapitalizedLetters(StringNormalizer.normalizeAndRemoveAccents(name.trim()));
        result = WHITESPACE.matcher(result).replaceAll("-");
        result = NONLATIN.matcher(result).replaceAll("");
        return result.toLowerCase(Locale.ENGLISH);
    }
}

