/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.fenixedu.commons.spreadsheet.SpreadsheetXLSExporter;

public class Spreadsheet {
    private String name;
    private final List<Object> headers;
    private List<Row> rows = new ArrayList<Row>();
    private Spreadsheet next = null;

    public Spreadsheet(String name) {
        this(name, new ArrayList<Object>());
    }

    public Spreadsheet(String name, List<Object> header) {
        this.setName(name);
        this.headers = header;
    }

    public Spreadsheet addSpreadsheet(String name) {
        this.next = new Spreadsheet(name);
        return this.next;
    }

    public Spreadsheet addSpreadsheet(String name, List<Object> header) {
        this.next = new Spreadsheet(name, header);
        return this.next;
    }

    public Spreadsheet getNextSpreadsheet() {
        return this.next;
    }

    private int getHeaderIndex(String header) {
        int i = 0;
        for (Object o : this.headers) {
            if (header.equals(o)) {
                return i;
            }
            ++i;
        }
        this.setHeader(header);
        return i;
    }

    protected String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.substring(0, Math.min(31, name.length())).replace('(', '_').replace(')', '_');
    }

    protected List<Object> getHeader() {
        return this.headers;
    }

    public Spreadsheet setHeader(int columnNumber, String columnHeader) {
        for (int i = this.headers.size(); i < columnNumber; ++i) {
            this.headers.add("");
        }
        this.headers.add(columnNumber, columnHeader);
        return this;
    }

    public Spreadsheet setHeader(String columnHeader) {
        this.headers.add(columnHeader);
        return this;
    }

    public Spreadsheet setHeaders(String ... headers) {
        for (int i = 0; i < headers.length; ++i) {
            this.setHeader(i, headers[i]);
        }
        return this;
    }

    public Row addRow(int rowNumber) {
        for (int i = this.rows.size(); i < rowNumber; ++i) {
            this.rows.add(new Row());
        }
        return this.addRow();
    }

    public Row addRow() {
        Row row = new Row();
        this.rows.add(row);
        return row;
    }

    public Row getRow(int rowNumber) {
        return this.rows.get(rowNumber);
    }

    public List<Row> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public void exportToCSV(OutputStream outputStream, String columnSeperator) throws IOException {
        this.exportToCSV(outputStream, columnSeperator, "\n");
    }

    public void exportToCSV(OutputStream outputStream, String columnSeperator, String lineSepeator) throws IOException {
        this.exportCSVLine(outputStream, columnSeperator, lineSepeator, this.headers);
        for (Row row : this.rows) {
            this.exportCSVLine(outputStream, columnSeperator, lineSepeator, row.getCells());
        }
    }

    public void exportToCSV(File file, String columnSeperator) throws IOException {
        FilterOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.exportToCSV(outputStream, columnSeperator);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void exportToCSV(File file, String columnSeperator, String lineSepeator) throws IOException {
        FilterOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.exportToCSV(outputStream, columnSeperator, lineSepeator);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void exportCSVLine(OutputStream outputStream, String columnSeperator, String lineSepeator, List<Object> cells) throws IOException {
        byte[] columnSeperatorAsBytes = columnSeperator.getBytes();
        for (int i = 0; i < cells.size(); ++i) {
            Object cellValue = cells.get(i);
            if (i > 0) {
                outputStream.write(columnSeperatorAsBytes);
            }
            if (cellValue == null) {
                outputStream.write("".getBytes());
                continue;
            }
            outputStream.write(cellValue.toString().replace(columnSeperator, "").getBytes());
        }
        outputStream.write(lineSepeator.getBytes());
    }

    public void exportToXLSSheet(OutputStream outputStream) throws IOException {
        new SpreadsheetXLSExporter().exportToXLSSheet(this, outputStream);
    }

    public void exportToXLSSheet(File file) throws IOException {
        new SpreadsheetXLSExporter().exportToXLSSheet(this, file);
    }

    public void exportToXLSSheet(HSSFWorkbook workbook, HSSFCellStyle headerCellStyle, HSSFCellStyle cellStyle) {
        new SpreadsheetXLSExporter().exportToXLSSheet(workbook, this, headerCellStyle, cellStyle);
    }

    public static void exportToXLSSheets(OutputStream outputStream, List<Spreadsheet> spreadsheets) throws IOException {
        new SpreadsheetXLSExporter().exportToXLSSheets(outputStream, spreadsheets);
    }

    public class Row {
        private final List<Object> cells = new ArrayList<Object>();

        protected Row() {
        }

        public Row setCell(int columnIndex, String cellValue) {
            for (int i = this.cells.size(); i < columnIndex + 1; ++i) {
                this.cells.add("");
            }
            this.cells.set(columnIndex, cellValue);
            return this;
        }

        public Row setCell(String cellValue) {
            this.cells.add(cellValue);
            return this;
        }

        public Row setCell(Integer cellValue) {
            this.cells.add(cellValue != null ? cellValue.toString() : "");
            return this;
        }

        public Row setCell(Double cellValue) {
            this.cells.add(cellValue != null ? cellValue.toString() : "");
            return this;
        }

        public Row setCell(BigDecimal cellValue) {
            this.cells.add(cellValue != null ? cellValue.toPlainString() : "");
            return this;
        }

        public Row setCell(Boolean cellValue) {
            this.cells.add(cellValue != null ? cellValue.toString() : "");
            return this;
        }

        public Row setCell(String header, String cellValue) {
            this.setCell(Spreadsheet.this.getHeaderIndex(header), cellValue);
            return this;
        }

        public Row setCell(String header, Integer cellValue) {
            this.setCell(Spreadsheet.this.getHeaderIndex(header), cellValue != null ? cellValue.toString() : "");
            return this;
        }

        public Row setCell(String header, Double cellValue) {
            this.setCell(Spreadsheet.this.getHeaderIndex(header), cellValue != null ? cellValue.toString() : "");
            return this;
        }

        public Row setCell(String header, BigDecimal cellValue) {
            this.setCell(Spreadsheet.this.getHeaderIndex(header), cellValue != null ? cellValue.toPlainString() : "");
            return this;
        }

        public Row setValues(String[] values) {
            for (int i = 0; i < values.length; ++i) {
                this.setCell(i, values[i]);
            }
            return this;
        }

        public List<Object> getCells() {
            return Collections.unmodifiableList(this.cells);
        }
    }
}

