/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class SheetData<Item> {
    final List<List<Cell>> headers = new ArrayList<List<Cell>>();
    final List<List<Cell>> matrix = new ArrayList<List<Cell>>();
    final List<Cell> footer = new ArrayList<Cell>();
    private boolean isHeader = true;
    private boolean isFooter = false;
    private List<Cell> current;

    public SheetData(Iterable<Item> items) {
        this.headers.add(new ArrayList());
        Iterator<Item> iterator = items.iterator();
        Item curr = null;
        Item prev = null;
        boolean include = false;
        while (iterator.hasNext()) {
            while (!(include = this.filter(curr = (Item)iterator.next())) && iterator.hasNext()) {
            }
            if (!include) continue;
            if (prev != null) {
                this.current = new ArrayList<Cell>();
                this.makeLine(prev);
                this.matrix.add(this.current);
                this.isHeader = false;
            }
            prev = curr;
        }
        if (prev != null) {
            this.isFooter = true;
            this.current = new ArrayList<Cell>();
            this.makeLine(prev);
            this.matrix.add(this.current);
        }
        Collections.reverse(this.headers);
    }

    protected abstract void makeLine(Item var1);

    protected boolean filter(Item item) {
        return true;
    }

    protected void addCell(Object header, Object value) {
        if (this.isHeader) {
            this.addHeader(new Object[]{header}, new short[]{1});
        }
        this.addCell(value);
        if (this.isFooter) {
            this.addFooter(null);
        }
    }

    protected void addCell(Object upHeader, short upSpan, Object header, short span, Object value, short valueSpan) {
        this.addCell(new Object[]{upHeader, header}, new short[]{upSpan, span}, value, valueSpan);
    }

    protected void addCell(Object[] headers, short[] headerSpans, Object value, short valueSpan) {
        if (this.isHeader) {
            this.addHeader(headers, headerSpans);
        }
        this.addCell(value, valueSpan);
        if (this.isFooter) {
            this.addFooter(null);
        }
    }

    protected void addCell(Object header, Object value, Object footer) {
        if (this.isHeader) {
            this.addHeader(new Object[]{header}, new short[]{1});
        }
        this.addCell(value);
        if (this.isFooter) {
            this.addFooter(footer, (short)1);
        }
    }

    protected void addCell(Object upHeader, short upSpan, Object header, short span, Object value, short valueSpan, Object footer, short footerSpan) {
        this.addCell(new Object[]{upHeader, header}, new short[]{upSpan, span}, value, valueSpan, footer, footerSpan);
    }

    protected void addCell(Object[] headers, short[] headerSpans, Object value, short valueSpan, Object footer, short footerSpan) {
        if (this.isHeader) {
            this.addHeader(headers, headerSpans);
        }
        this.addCell(value, valueSpan);
        if (this.isFooter) {
            this.addFooter(footer, footerSpan);
        }
    }

    private void addHeader(Object[] headers, short[] spans) {
        int i;
        int currentColumn = this.headers.get(0).size();
        if (this.headers.size() < headers.length) {
            for (i = headers.length - this.headers.size(); i > 0; --i) {
                this.headers.add(new ArrayList());
            }
        }
        for (i = headers.length - 1; i >= 0; --i) {
            Object header = headers[i];
            short span = spans[i];
            List<Cell> headerRow = this.headers.get(headers.length - i - 1);
            int column = 0;
            for (Cell cell : headerRow) {
                column += cell.span;
            }
            if (currentColumn - column > 0) {
                headerRow.add(new Cell("", (short)(currentColumn - column)));
            }
            headerRow.add(new Cell(header, span));
        }
    }

    private void addFooter(Object footer) {
        this.addFooter(footer, (short)1);
    }

    private void addFooter(Object footer, short hspan) {
        this.footer.add(new Cell(footer, hspan));
    }

    protected void addCell(Object value) {
        this.addCell(value, (short)1);
    }

    protected void addCell(Object value, short hspan) {
        this.current.add(new Cell(value, hspan));
    }

    public boolean hasFooter() {
        if (!this.footer.isEmpty()) {
            for (Cell cell : this.footer) {
                if (cell.value == null) continue;
                return true;
            }
        }
        return false;
    }

    public static class Cell {
        Object value;
        short span;

        public Cell(Object value, short span) {
            this.value = value;
            this.span = span;
        }
    }
}

