/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.i18n;

import java.util.Locale;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18N {
    private static final Logger logger = LoggerFactory.getLogger(I18N.class);
    private static final String LOCALE_KEY = I18N.class.getName() + "_LOCAL_KEY";
    private static final InheritableThreadLocal<Locale> locale = new InheritableThreadLocal();

    public static Locale getLocale() {
        return locale.get() != null ? (Locale)locale.get() : Locale.getDefault();
    }

    public static void setLocale(HttpSession session, Locale locale) {
        if (session != null) {
            session.setAttribute(LOCALE_KEY, (Object)locale);
        }
        I18N.setLocale(locale);
    }

    public static void setLocale(Locale locale) {
        I18N.locale.set(locale);
        logger.trace("Set locale to: {}", (Object)locale);
    }

    public static void updateFromSession(HttpSession session) {
        if (session != null && session.getAttribute(LOCALE_KEY) != null) {
            locale.set((Locale)session.getAttribute(LOCALE_KEY));
            logger.trace("Set thread's locale to: {}", (Object)((Locale)locale.get()).toString());
        } else {
            locale.set(null);
        }
    }
}

