/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.groups.PersistentDynamicGroup;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.cms.domain.CmsSettings_Base;
import org.fenixedu.cms.exceptions.CmsDomainException;

public class CmsSettings
extends CmsSettings_Base {
    private CmsSettings() {
        PersistentDynamicGroup managers = Group.managers().toPersistentGroup();
        this.setFoldersManagers((PersistentGroup)managers);
        this.setRolesManagers((PersistentGroup)managers);
        this.setSettingsManagers((PersistentGroup)managers);
        this.setThemesManagers((PersistentGroup)managers);
    }

    public boolean canManageFolders() {
        return this.getFoldersManagers().isMember(Authenticate.getUser());
    }

    public boolean canManageRoles() {
        return this.getRolesManagers().isMember(Authenticate.getUser());
    }

    public boolean canManageSettings() {
        return this.getSettingsManagers().isMember(Authenticate.getUser());
    }

    public boolean canManageThemes() {
        return this.getThemesManagers().isMember(Authenticate.getUser());
    }

    public boolean canManageGlobalPermissions() {
        return Group.managers().isMember(Authenticate.getUser());
    }

    public void ensureCanManageFolders() {
        if (!this.canManageFolders()) {
            throw CmsDomainException.forbiden();
        }
    }

    public void ensureCanManageRoles() {
        if (!this.canManageRoles()) {
            throw CmsDomainException.forbiden();
        }
    }

    public void ensureCanManageSettings() {
        if (!this.canManageSettings()) {
            throw CmsDomainException.forbiden();
        }
    }

    public void ensureCanManageThemes() {
        if (!this.canManageThemes()) {
            throw CmsDomainException.forbiden();
        }
    }

    public void ensureCanManageGlobalPermissions() {
        if (!this.canManageGlobalPermissions()) {
            throw CmsDomainException.forbiden();
        }
    }

    public static CmsSettings getInstance() {
        if (Bennu.getInstance().getCmsSettings() == null) {
            CmsSettings.init();
        }
        return Bennu.getInstance().getCmsSettings();
    }

    public static void init() {
        if (Bennu.getInstance().getCmsSettings() == null) {
            Bennu.getInstance().setCmsSettings(new CmsSettings());
        }
    }
}

