/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.io.domain.GroupBasedFile;
import org.fenixedu.cms.domain.CMSTemplate;
import org.fenixedu.cms.domain.CMSTheme;
import org.fenixedu.cms.domain.CMSThemeFile;
import org.fenixedu.cms.domain.CMSThemeFiles;
import org.fenixedu.cms.domain.CMSThemeLoader$callable$getOrCreateTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CMSThemeLoader {
    static final Pattern RELATIVE_PARENT;
    static final Pattern RELATIVE_CURRENT;
    static final Pattern FULL_PATH;
    public static Logger LOGGER;
    public static final Advice advice$getOrCreateTheme;

    private static List<EntryBean> getFolderEntries(ZipInputStream zin) {
        ArrayList zipEntryBeans = Lists.newArrayList();
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zin.getNextEntry()) != null) {
                zipEntryBeans.add(new ZipEntryBean(zin, zipEntry));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return zipEntryBeans;
    }

    public static CMSTheme createFromZipStream(ZipInputStream zin) {
        return CMSThemeLoader.create(CMSThemeLoader.getFolderEntries(zin));
    }

    public static CMSTheme createFromZip(ZipFile zipFile) {
        return CMSThemeLoader.create(CMSThemeLoader.getZipEntries(zipFile));
    }

    public static CMSTheme createFromFolder(File folder) {
        return CMSThemeLoader.create(CMSThemeLoader.getFolderEntries(folder, folder));
    }

    private static List<EntryBean> getFolderEntries(File folder, File root) {
        ArrayList folderChildren = Lists.newArrayList();
        for (File child : folder.listFiles()) {
            folderChildren.add(new FileEntryBean(child, root));
            if (!child.isDirectory()) continue;
            folderChildren.addAll(CMSThemeLoader.getFolderEntries(child, root));
        }
        return folderChildren;
    }

    private static List<EntryBean> getZipEntries(ZipFile zipFile) {
        ArrayList zipEntryBeans = Lists.newArrayList();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            zipEntryBeans.add(new ZipEntryBean(zipFile, zipEntry));
        }
        return zipEntryBeans;
    }

    private static CMSTheme create(List<EntryBean> entries) {
        JsonObject themeDescription = entries.stream().filter(entry -> entry.getName().endsWith("theme.json")).map(entry -> new JsonParser().parse(new String(entry.getContent())).getAsJsonObject()).findAny().orElseThrow(() -> new IllegalArgumentException("Theme does not contain a theme.json file!"));
        CMSThemeFiles themeFiles = new CMSThemeFiles(CMSThemeLoader.loadFiles(entries.stream().filter(entry -> !entry.getName().equals("theme.json") && CMSThemeLoader.validName(entry.getName()) && !entry.isDirectory())));
        return CMSThemeLoader.getOrCreateTheme(themeFiles, themeDescription);
    }

    private static boolean validName(String name) {
        return !name.contains("__MACOSX") && !name.contains("DS_Store") && !RELATIVE_PARENT.matcher(name).matches() && !RELATIVE_CURRENT.matcher(name).matches() && !FULL_PATH.matcher(name).matches();
    }

    private static CMSTheme getOrCreateTheme(CMSThemeFiles cMSThemeFiles, JsonObject jsonObject) {
        return (CMSTheme)((Object)advice$getOrCreateTheme.perform((Callable)new CMSThemeLoader$callable$getOrCreateTheme(cMSThemeFiles, jsonObject)));
    }

    static /* synthetic */ CMSTheme advised$getOrCreateTheme(CMSThemeFiles files, JsonObject themeDef) {
        String themeType = themeDef.get("type").getAsString();
        CMSTheme theme = CMSTheme.forType(themeType);
        if (theme != null) {
            return theme;
        }
        theme = new CMSTheme();
        theme.setDescription(themeDef.get("description").getAsString());
        theme.setName(themeDef.get("name").getAsString());
        theme.setBennu(Bennu.getInstance());
        theme.setType(themeType);
        HashSet refused = Sets.newHashSet((Iterable)theme.getTemplatesSet());
        CMSThemeLoader.loadExtends(themeDef, theme);
        CMSThemeLoader.loadPageTemplates(themeDef, theme, refused, files);
        for (CMSTemplate t : refused) {
            if (t.getPagesSet().size() != 0) {
                throw new RuntimeException("Cannot replace theme, '" + t.getType() + "' is being used in some pages but is not included in new theme.");
            }
            t.delete();
        }
        theme.setFiles(files);
        if (themeDef.has("thumbnail")) {
            CMSThemeFile thumbnail = theme.fileForPath(themeDef.get("thumbnail").getAsString());
            theme.setPreviewImage(new GroupBasedFile(thumbnail.getFileName(), thumbnail.getFullPath(), thumbnail.getContent(), Group.anyone()));
            theme.setPreviewImagePath(themeDef.get("thumbnail").getAsString());
        }
        if (Bennu.getInstance().getCMSThemesSet().size() == 1) {
            Bennu.getInstance().setDefaultCMSTheme(theme);
        }
        return theme;
    }

    private static void loadExtends(JsonObject themeDef, CMSTheme theme) {
        String type;
        if (themeDef.has("extends") && (type = themeDef.get("extends").getAsString()) != null) {
            CMSTheme parent = CMSTheme.forType(type);
            if (parent == null) {
                throw new RuntimeException("Extended theme does not exist");
            }
            theme.setExtended(parent);
        }
    }

    private static void loadPageTemplates(JsonObject themeDef, CMSTheme theme, HashSet<CMSTemplate> refused, CMSThemeFiles files) {
        for (Map.Entry entry : themeDef.get("templates").getAsJsonObject().entrySet()) {
            String type = (String)entry.getKey();
            JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
            CMSTemplate tp = Optional.ofNullable(theme.templateForType(type)).orElseGet(() -> new CMSTemplate());
            tp.setName(obj.get("name").getAsString());
            tp.setDescription(obj.get("description").getAsString());
            tp.setType(type);
            tp.setTheme(theme);
            if (refused.contains((Object)tp)) {
                refused.remove((Object)tp);
            }
            String path = obj.get("file").getAsString();
            CMSThemeFile file = files.getFileForPath(path);
            tp.setFilePath(path);
            if (file != null) continue;
            throw new RuntimeException("File in template '" + type + "' isn't in the Zip.");
        }
    }

    private static Map<String, CMSThemeFile> loadFiles(Stream<EntryBean> files) {
        HashMap<String, CMSThemeFile> fileMap = new HashMap<String, CMSThemeFile>();
        files.forEach(bean -> {
            String filename = bean.getName();
            fileMap.put(bean.getName(), new CMSThemeFile(Paths.get(filename, new String[0]).getFileName().toString(), filename, bean.getContent()));
        });
        return fileMap;
    }

    static {
        advice$getOrCreateTheme = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        RELATIVE_PARENT = Pattern.compile("^../|/../|/..$");
        RELATIVE_CURRENT = Pattern.compile("^./|/./|/.$");
        FULL_PATH = Pattern.compile("^/.*");
        LOGGER = LoggerFactory.getLogger(CMSThemeLoader.class);
    }

    private static class ZipEntryBean
    extends EntryBean {
        private final byte[] bytes;

        public ZipEntryBean(ZipFile zipFile, ZipEntry zipEntry) {
            super(zipEntry.getName(), zipEntry.isDirectory());
            try {
                this.bytes = ByteStreams.toByteArray((InputStream)zipFile.getInputStream(zipEntry));
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading the content of the zip file entry", e);
            }
        }

        public ZipEntryBean(ZipInputStream zin, ZipEntry zipEntry) {
            super(zipEntry.getName(), zipEntry.isDirectory());
            try {
                this.bytes = ByteStreams.toByteArray((InputStream)zin);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading the content of the zip file entry", e);
            }
        }

        @Override
        public byte[] getContent() {
            return this.bytes;
        }
    }

    private static class FileEntryBean
    extends EntryBean {
        private final File file;

        public FileEntryBean(File file, File root) {
            super(root.toURI().relativize(file.toURI()).getPath(), file.isDirectory());
            this.file = file;
        }

        @Override
        public byte[] getContent() {
            try {
                return ByteStreams.toByteArray((InputStream)new FileInputStream(this.file));
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading the content of the zip file entry", e);
            }
        }
    }

    private static abstract class EntryBean {
        private final String name;
        private final boolean isDirectory;

        public EntryBean(String name, boolean isDirectory) {
            this.name = name;
            this.isDirectory = isDirectory;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public abstract byte[] getContent();
    }
}

