/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain.component;

import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.fenixedu.cms.domain.CloneCache;
import org.fenixedu.cms.domain.Cloneable;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Page_Base;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.component.ComponentContextProvider;
import org.fenixedu.cms.domain.component.ComponentParameter;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.domain.component.DynamicComponent;
import org.fenixedu.cms.domain.component.StaticPost$callable$delete;
import org.fenixedu.cms.domain.component.StaticPost_Base;
import org.fenixedu.cms.rendering.TemplateContext;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@ComponentType(name="Static Post", description="Static Post")
public class StaticPost
extends StaticPost_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @DynamicComponent
    public StaticPost(@ComponentParameter(value="Post", provider=PostsForSite.class) Post post) {
        this.setPost(post);
    }

    @DynamicComponent
    private StaticPost(JsonObject json) {
        this(Site.fromSlug(json.get("site").getAsString()).postForSlug(json.get("post").getAsString()));
    }

    public void handle(Page page, TemplateContext local, TemplateContext global) {
        Post post = this.getPost();
        local.put("post", post.makeWrap());
        global.put("post", post.makeWrap());
    }

    public StaticPost clone(CloneCache cloneCache) {
        return cloneCache.getOrClone(this, obj -> {
            StaticPost clone = new StaticPost((Post)null);
            cloneCache.setClone(this, (Cloneable)((Object)clone));
            clone.setPost(this.getPost().clone(cloneCache));
            return clone;
        });
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new StaticPost$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(StaticPost this_) {
        this_.setPost(null);
        super.delete();
    }

    public String getName() {
        String name = super.getName();
        return name + " (" + this.getPost().getName().getContent() + ")";
    }

    public Page getPage() {
        if (this.getInstalledPageSet().isEmpty()) {
            return null;
        }
        return (Page)this.getInstalledPageSet().iterator().next();
    }

    public JsonObject json() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.getType());
        jsonObject.addProperty("post", this.getPost().getSlug());
        jsonObject.addProperty("site", this.getPost().getSite().getSlug());
        jsonObject.addProperty("page", (String)Optional.ofNullable(this.getPage()).map(Page_Base::getSlug).orElse(null));
        return jsonObject;
    }

    public static class PostsForSite
    implements ComponentContextProvider<Post> {
        @Override
        public Collection<Post> provide(Page page) {
            return page.getSite().getPostSet();
        }

        @Override
        public String present(Post post) {
            return post.getName().getContent();
        }
    }
}

