/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.domain.MenuItem;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.cms.CMSConfigurationManager;
import org.fenixedu.cms.domain.CMSFolder;
import org.fenixedu.cms.domain.CMSTheme;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.CloneCache;
import org.fenixedu.cms.domain.Cloneable;
import org.fenixedu.cms.domain.Menu;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.PersistentSiteViewersGroup;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.Role;
import org.fenixedu.cms.domain.Site$callable$delete;
import org.fenixedu.cms.domain.Site$callable$deleteMenuFunctionality;
import org.fenixedu.cms.domain.Site$callable$getOrCreateCategoryForSlug;
import org.fenixedu.cms.domain.Site$callable$setCanViewGroup;
import org.fenixedu.cms.domain.SiteActivity;
import org.fenixedu.cms.domain.SiteViewersGroup;
import org.fenixedu.cms.domain.Site_Base;
import org.fenixedu.cms.domain.SlugUtils;
import org.fenixedu.cms.domain.Sluggable;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.component.ListCategoryPosts;
import org.fenixedu.cms.domain.component.ViewPost;
import org.fenixedu.cms.domain.wraps.UserWrap;
import org.fenixedu.cms.domain.wraps.Wrap;
import org.fenixedu.cms.domain.wraps.Wrappable;
import org.fenixedu.cms.exceptions.CmsDomainException;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.consistencyPredicates.ConsistencyPredicate;

public class Site
extends Site_Base
implements Wrappable,
Sluggable,
Cloneable {
    public static final String SIGNAL_CREATED = "fenixedu.cms.site.created";
    public static final String SIGNAL_DELETED = "fenixedu.cms.site.deleted";
    public static final String SIGNAL_EDITED = "fenixedu.cms.site.edited";
    public static final Comparator<Site> NAME_COMPARATOR;
    public static final Comparator<Site> CREATION_DATE_COMPARATOR;
    private static final Logger logger;
    private Group defaultRoleTemplateRole;
    private static final Map<String, Site> siteCache;
    public static final Advice advice$setCanViewGroup;
    public static final Advice advice$getOrCreateCategoryForSlug;
    public static final Advice advice$deleteMenuFunctionality;
    public static final Advice advice$delete;

    protected Site() {
    }

    public Site(LocalizedString name, LocalizedString description) {
        if (Authenticate.getUser() == null) {
            throw CmsDomainException.forbiden();
        }
        this.setCreatedBy(Authenticate.getUser());
        this.setCreationDate(new DateTime());
        this.setCanViewGroup(Group.anyone());
        this.setBennu(Bennu.getInstance());
        new PersistentSiteViewersGroup(this);
        this.setName(name);
        this.setSlug(StringNormalizer.slugify((String)name.getContent()));
        this.setDescription(description);
        this.setPublished(false);
        Signal.emit((String)SIGNAL_CREATED, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public Group getCanViewGroup() {
        return this.getViewGroup().toGroup();
    }

    public void setCanViewGroup(Group group) {
        Object object = advice$setCanViewGroup.perform((Callable)new Site$callable$setCanViewGroup(this, group));
    }

    static /* synthetic */ void advised$setCanViewGroup(Site this_, Group group) {
        this_.setViewGroup(group.toPersistentGroup());
    }

    public static Site fromSlug(String slug) {
        if (slug == null) {
            return null;
        }
        Site match = siteCache.computeIfAbsent(slug, Site::manualFind);
        if (match == null) {
            throw CmsDomainException.notFound();
        }
        if (!FenixFramework.isDomainObjectValid((DomainObject)match) || !match.getSlug().equals(slug)) {
            siteCache.remove(slug, match);
            return Site.fromSlug(slug);
        }
        return match;
    }

    private static Site manualFind(String slug) {
        return Bennu.getInstance().getSitesSet().stream().filter(site -> site.getSlug() != null && site.getSlug().equals(slug)).findAny().orElse(null);
    }

    public Page pageForSlug(String slug) {
        return this.getPagesSet().stream().filter(page -> slug.equals(page.getSlug())).findAny().orElseThrow(() -> CmsDomainException.notFound());
    }

    public Page archivedPageForSlug(String slug) {
        return this.getArchivedPagesSet().stream().filter(post -> slug.equals(post.getSlug())).findAny().orElse(null);
    }

    public Post postForSlug(String slug) {
        return this.getPostSet().stream().filter(post -> slug.equals(post.getSlug())).findAny().orElse(null);
    }

    public Post archivedPostForSlug(String slug) {
        return this.getArchivedPostsSet().stream().filter(post -> slug.equals(post.getSlug())).findAny().orElse(null);
    }

    public Category categoryForSlug(String slug) {
        return this.getCategoriesSet().stream().filter(category -> slug.equals(category.getSlug())).findAny().orElseThrow(() -> CmsDomainException.notFound());
    }

    public Category getOrCreateCategoryForSlug(String string, LocalizedString localizedString) {
        return (Category)advice$getOrCreateCategoryForSlug.perform((Callable)new Site$callable$getOrCreateCategoryForSlug(this, string, localizedString));
    }

    static /* synthetic */ Category advised$getOrCreateCategoryForSlug(Site this_, String slug, LocalizedString name) {
        try {
            return this_.categoryForSlug(slug);
        }
        catch (CmsDomainException e) {
            Category category = new Category(this_, name);
            category.setSlug(slug);
            return category;
        }
    }

    @Override
    public void setSlug(String slug) {
        String oldSlug = this.getSlug();
        super.setSlug(SlugUtils.makeSlug(this, slug));
        logger.debug("Site " + this.getExternalId() + " slug changed from " + oldSlug + " to " + this.getSlug() + " by user " + Authenticate.getUser().getUsername());
    }

    public void setNameToSuper(LocalizedString name) {
        super.setName(name);
    }

    public void setName(LocalizedString name) {
        LocalizedString prevName = this.getName();
        super.setName(name);
        if (prevName == null) {
            String slug = StringNormalizer.slugify((String)name.getContent());
            this.setSlug(slug);
        }
    }

    public Menu menuForOid(String oid) {
        Menu menu = (Menu)FenixFramework.getDomainObject((String)oid);
        if (menu == null || menu.getSite() != this) {
            return null;
        }
        return menu;
    }

    public Menu menuForSlug(String slug) {
        return this.getMenusSet().stream().filter(x -> slug.equals(x.getSlug())).findAny().orElse(null);
    }

    private void deleteMenuFunctionality() {
        Object object = advice$deleteMenuFunctionality.perform((Callable)new Site$callable$deleteMenuFunctionality(this));
    }

    static /* synthetic */ void advised$deleteMenuFunctionality(Site this_) {
        MenuFunctionality mf = this_.getFunctionality();
        this_.setFunctionality(null);
        mf.delete();
    }

    public void updateMenuFunctionality() {
        Preconditions.checkNotNull((Object)this.getDescription());
        Preconditions.checkNotNull((Object)this.getName());
        Preconditions.checkNotNull((Object)this.getSlug());
        Preconditions.checkArgument((boolean)this.isValidSlug(this.getSlug()));
        if (this.getFolder() == null) {
            MenuContainer parent;
            MenuContainer menuContainer = parent = this.getFunctionality() == null ? PortalConfiguration.getInstance().getMenu() : this.getFunctionality().getParent();
            if (this.getFunctionality() != null) {
                this.deleteMenuFunctionality();
            }
            this.setFunctionality(new MenuFunctionality(parent, this.getEmbedded(), this.getSlug(), this.getEmbedded() ? "cms-embedded" : "cms", "anyone", this.getDescription(), this.getName(), this.getSlug()));
            this.getFunctionality().setAccessGroup(SiteViewersGroup.get(this));
        }
    }

    public TreeSet<Menu> getOrderedMenusSet() {
        TreeSet<Menu> menus = new TreeSet<Menu>();
        this.getMenusSet().stream().sorted().forEach(m -> menus.add((Menu)m));
        return menus;
    }

    @Override
    public Site clone(CloneCache cloneCache) {
        return cloneCache.getOrClone(this, obj -> {
            HashSet pages = new HashSet(this.getPagesSet());
            HashSet menus = new HashSet(this.getMenusSet());
            HashSet categories = new HashSet(this.getCategoriesSet());
            HashSet posts = new HashSet(this.getPostSet());
            LocalizedString name = this.getName() != null ? LocalizedString.fromJson((JsonElement)this.getName().json()) : null;
            LocalizedString description = this.getDescription() != null ? LocalizedString.fromJson((JsonElement)this.getDescription().json()) : null;
            Site clone = new Site(name, description);
            cloneCache.setClone(this, clone);
            clone.setCanViewGroup(this.getCanViewGroup());
            clone.setThemeType(this.getThemeType());
            clone.setTheme(this.getTheme());
            clone.setEmbedded(this.getEmbedded());
            clone.setFolder(this.getFolder());
            clone.setAlternativeSite(this.getAlternativeSite());
            clone.setAnalyticsCode(this.getAnalyticsCode());
            clone.setStyle(this.getStyle());
            clone.setPrimaryBennu(this.getPrimaryBennu());
            clone.setBennu(this.getBennu());
            for (Page originalPage : pages) {
                Page pageClone = originalPage.clone(cloneCache);
                clone.addPages(pageClone);
                pageClone.setSlug(originalPage.getSlug());
            }
            for (Post originalPost : posts) {
                Post postClone = originalPost.clone(cloneCache);
                clone.addPost(postClone);
                postClone.setSlug(originalPost.getSlug());
            }
            for (Menu originalMenu : menus) {
                Menu menuClone = originalMenu.clone(cloneCache);
                clone.addMenus(menuClone);
                menuClone.setSlug(originalMenu.getSlug());
            }
            for (Category originalCategory : categories) {
                Category categoryClone = originalCategory.clone(cloneCache);
                clone.addCategories(categoryClone);
                categoryClone.setSlug(originalCategory.getSlug());
            }
            clone.setInitialPage(this.getInitialPage() != null ? this.getInitialPage().clone(cloneCache) : null);
            clone.updateMenuFunctionality();
            return clone;
        });
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Site$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Site this_) {
        logger.debug("Site " + this_.getSlug() + " - " + this_.getExternalId() + " deleted by user " + Authenticate.getUser().getUsername());
        Signal.emit((String)SIGNAL_DELETED, (Object)this_.getOid());
        MenuFunctionality mf = this_.getFunctionality();
        this_.setFunctionality(null);
        this_.setFolder(null);
        this_.setInitialPage(null);
        if (mf != null) {
            mf.delete();
        }
        this_.getViewerGroup().delete();
        this_.setViewGroup(null);
        this_.setTheme(null);
        this_.setCreatedBy(null);
        this_.setBennu(null);
        this_.setBuilder(null);
        this_.setDefaultRoleTemplate(null);
        this_.getActivityLinesSet().stream().forEach(SiteActivity::delete);
        this_.getPostSet().stream().forEach(Post::delete);
        this_.getCategoriesSet().stream().forEach(Category::delete);
        this_.getMenusSet().stream().forEach(Menu::delete);
        this_.getPagesSet().stream().forEach(Page::delete);
        this_.getRolesSet().stream().forEach(Role::delete);
        this_.deleteDomainObject();
    }

    public Page getViewPostPage() {
        for (Page page : this.getPagesSet()) {
            for (Component component : page.getComponentsSet()) {
                if (component.componentType() != ViewPost.class) continue;
                return page;
            }
        }
        return null;
    }

    public boolean isDefault() {
        return Bennu.getInstance().getDefaultSite() == this;
    }

    public Page getViewCategoryPage() {
        for (Page page : this.getPagesSet()) {
            for (Component component : page.getComponentsSet()) {
                if (component.getClass() != ListCategoryPosts.class) continue;
                return page;
            }
        }
        return null;
    }

    public String getStaticDirectory() {
        if (CMSConfigurationManager.isInThemeDevelopmentMode()) {
            return CoreConfiguration.getConfiguration().applicationUrl() + "/" + this.getBaseUrl() + "/static";
        }
        return this.getTheme().getAssetsPath();
    }

    @Override
    public boolean isValidSlug(String slug) {
        Stream menuItems = PortalConfiguration.getInstance().getMenu().getOrderedChild().stream();
        return !Strings.isNullOrEmpty((String)slug) && (slug.equals(this.getSlug()) || menuItems.map(MenuItem::getPath).noneMatch(path -> path.equals(slug)));
    }

    public String getBaseUrl() {
        if (this.getFolder() != null) {
            return this.getFolder().getBaseUrl(this);
        }
        return this.getSlug();
    }

    public List<Post> getLatestPosts() {
        return this.getPostSet().stream().sorted(Post.CREATION_DATE_COMPARATOR).limit(5L).collect(Collectors.toList());
    }

    public String getFullUrl() {
        return CoreConfiguration.getConfiguration().applicationUrl() + "/" + this.getBaseUrl();
    }

    public String getRssUrl() {
        return this.getFullUrl() + "/rss";
    }

    public String getEditUrl() {
        return CoreConfiguration.getConfiguration().applicationUrl() + "/cms/sites/" + this.getSlug();
    }

    public void setFolder(CMSFolder folder) {
        super.setFolder(folder);
        if (folder != null && this.getFunctionality() != null) {
            this.deleteMenuFunctionality();
        }
        logger.debug("Site " + this.getSlug() + " - " + this.getExternalId() + " folder changed by user " + Authenticate.getUser().getUsername());
    }

    @ConsistencyPredicate
    public boolean checkHasEitherFunctionalityOrFolder() {
        return this.getFunctionality() != null || this.getFolder() != null;
    }

    public Role getDefaultRoleTemplateRole() {
        return this.getRolesSet().stream().filter(role -> role.getRoleTemplate().equals((Object)this.getDefaultRoleTemplate())).findAny().orElseGet(() -> null);
    }

    @Override
    public Wrap makeWrap() {
        return new SiteWrap();
    }

    public List<Page> getSortedPages() {
        return this.getPagesSet().stream().sorted(Comparator.comparing(page -> page.getName().getContent())).collect(Collectors.toList());
    }

    public void setTheme(CMSTheme theme) {
        super.setTheme(theme);
        if (theme != null) {
            this.setThemeType(theme.getType());
        } else {
            this.setThemeType(null);
        }
        logger.debug("Site " + this.getSlug() + " theme changed by user " + Authenticate.getUser());
    }

    public CMSTheme getTheme() {
        String themeType = this.getThemeType();
        CMSTheme theme = super.getTheme();
        if (themeType != null) {
            if (theme != null && theme.getType().equals(themeType)) {
                return theme;
            }
            CMSTheme otherTheme = CMSTheme.forType(themeType);
            if (otherTheme == null) {
                return CMSTheme.getDefaultTheme();
            }
            return otherTheme;
        }
        return null;
    }

    public void pushActivity(SiteActivity siteActivity) {
        siteActivity.setNext(null);
        siteActivity.setPrevious(this.getLastActivityLine());
        this.setLastActivityLine(siteActivity);
    }

    public List<SiteActivities> getLastFiveDaysOfActivity() {
        ArrayList result = Lists.newArrayList();
        DateTime current = null;
        List day = null;
        for (SiteActivity pivot = this.getLastActivityLine(); pivot != null; pivot = pivot.getPrevious()) {
            DateTime date = pivot.getEventDate();
            if (!date.equals(current)) {
                if (result.size() == 5) break;
                day = Lists.newArrayList();
                SiteActivities sas = new SiteActivities();
                sas.setItems(day);
                sas.setDate(date);
                result.add(0, sas);
                current = date;
            }
            day.add(0, pivot);
        }
        return result.subList(0, Math.min(result.size(), 10));
    }

    public Stream<Post> getStaticPostsStream() {
        return this.getPostSet().stream().filter(Post::isStaticPost).sorted(Post.CREATION_DATE_COMPARATOR);
    }

    public Stream<Post> getNonStaticPostsStream() {
        return this.getPostSet().stream().filter(p -> !p.isStaticPost()).sorted(Post.CREATION_DATE_COMPARATOR);
    }

    public Stream<Post> getNonStaticArchivedPostsStream() {
        return this.getArchivedPostsSet().stream().filter(p -> !p.isStaticPost()).sorted(Post.CREATION_DATE_COMPARATOR);
    }

    static {
        advice$setCanViewGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$getOrCreateCategoryForSlug = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$deleteMenuFunctionality = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        NAME_COMPARATOR = Comparator.comparing(Site_Base::getName, Comparator.nullsLast(Comparator.naturalOrder()));
        CREATION_DATE_COMPARATOR = Comparator.comparing(Site_Base::getCreationDate);
        logger = LoggerFactory.getLogger(Site.class);
        siteCache = new ConcurrentHashMap<String, Site>();
    }

    public class SiteWrap
    extends Wrap {
        public boolean canPost() {
            return true;
        }

        public LocalizedString getName() {
            return Site.this.getName();
        }

        public LocalizedString getDescription() {
            return Site.this.getDescription();
        }

        public UserWrap getCreatedBy() {
            return new UserWrap(Site.this.getCreatedBy());
        }

        public DateTime getCreationDate() {
            return Site.this.getCreationDate();
        }

        public String getRssUrl() {
            return Site.this.getRssUrl();
        }

        public String getAnalyticsCode() {
            return Site.this.getAnalyticsCode();
        }

        public String getAddress() {
            return Site.this.getFullUrl();
        }

        public String getEditAddress() {
            return Site.this.getEditUrl();
        }
    }

    public static class SiteActivities {
        private DateTime date;
        private List<SiteActivity> items;

        public DateTime getDate() {
            return this.date;
        }

        private void setDate(DateTime date) {
            this.date = date;
        }

        public List<SiteActivity> getItems() {
            return this.items;
        }

        private void setItems(List<SiteActivity> items) {
            this.items = items;
        }
    }
}

