/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.function.Function;
import org.fenixedu.cms.domain.Cloneable;
import pt.ist.fenixframework.DomainObject;

public class CloneCache {
    private HashMap<String, Cloneable> clonesCache = Maps.newHashMap();

    public <R extends DomainObject> R getOrClone(R object, Function<R, Cloneable> cloneCreator) {
        Preconditions.checkNotNull(object);
        if (!this.clonesCache.containsKey(object.getExternalId())) {
            this.clonesCache.put(object.getExternalId(), cloneCreator.apply(object));
        }
        return (R)((DomainObject)this.clonesCache.get(object.getExternalId()));
    }

    public <R extends DomainObject> void setClone(R object, Cloneable clone) {
        this.clonesCache.put(object.getExternalId(), clone);
    }
}

