/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain.component;

import java.util.HashMap;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.CMSComponent;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.domain.component.PostsPresentationBean;
import org.fenixedu.cms.rendering.TemplateContext;

@ComponentType(name="List Posts", description="List all non-static Posts")
public class ListPosts
implements CMSComponent {
    public static final int POSTS_PER_PAGE = 5;

    @Override
    public void handle(Page page, TemplateContext local, TemplateContext global) {
        PostsPresentationBean postsPresentation = new PostsPresentationBean(page.getSite().getPostSet());
        int currentPage = postsPresentation.currentPage(global.getParameter("p"));
        HashMap<String, Object> pagination = postsPresentation.paginate(page, currentPage, 5);
        local.put("posts", postsPresentation.getVisiblePosts());
        local.put("pagination", pagination);
        global.put("posts", postsPresentation.getVisiblePosts());
        global.put("pagination", pagination);
    }
}

