/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tika.io.FilenameUtils;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.domain.GroupBasedFile;
import org.fenixedu.bennu.io.servlet.FileDownloadServlet;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.Menu;
import org.fenixedu.cms.domain.MenuItem;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.PostFile;
import org.fenixedu.cms.domain.PostMetadata;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.SiteImporter$callable$importSite;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.component.ComponentDescriptor;
import org.fenixedu.cms.domain.component.ListCategoryPosts;
import org.fenixedu.cms.exceptions.CmsDomainException;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SiteImporter {
    private static final JsonParser PARSER;
    private final ZipFile zipFile;
    public static final Advice advice$importSite;

    public SiteImporter(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public Site importSite() {
        return (Site)advice$importSite.perform((Callable)new SiteImporter$callable$importSite(this));
    }

    static /* synthetic */ Site advised$importSite(SiteImporter this_) {
        JsonObject siteJson = this_.getSiteJson();
        Map<String, JsonObject> pagesDir = this_.readJsonDirectory("pages/");
        Map<String, JsonObject> postsDir = this_.readJsonDirectory("posts/");
        Map<String, JsonObject> categoriesDir = this_.readJsonDirectory("categories/");
        Map<String, JsonObject> menusDir = this_.readJsonDirectory("menus/");
        Site site = new Site(LocalizedString.fromJson((JsonElement)siteJson.get("name")), LocalizedString.fromJson((JsonElement)siteJson.get("description")));
        site.setSlug(siteJson.get("slug").getAsString());
        site.setCanViewGroup(Group.parse((String)siteJson.get("canViewGroup").getAsString()));
        if (siteJson.has("themeType") && !siteJson.get("themeType").isJsonNull()) {
            site.setThemeType(siteJson.get("themeType").getAsString());
        }
        site.setEmbedded(siteJson.get("embedded").getAsBoolean());
        if (siteJson.has("analyticsCode") && !siteJson.get("analyticsCode").isJsonNull()) {
            site.setAnalyticsCode(siteJson.get("analyticsCode").getAsString());
        }
        for (Map.Entry<String, JsonObject> entry : categoriesDir.entrySet()) {
            this_.importCategory(site, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, JsonObject> entry : postsDir.entrySet()) {
            this_.importPost(site, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, JsonObject> entry : pagesDir.entrySet()) {
            this_.importPage(site, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, JsonObject> entry : menusDir.entrySet()) {
            this_.importMenu(site, entry.getKey(), entry.getValue());
        }
        if (siteJson.has("initialPage") && !siteJson.get("initialPage").isJsonNull()) {
            site.setInitialPage(site.pageForSlug(siteJson.get("initialPage").getAsString()));
        }
        site.updateMenuFunctionality();
        return site;
    }

    private Page importPage(Site site, String pageSlug, JsonObject jsonObject) {
        try {
            return site.pageForSlug(pageSlug);
        }
        catch (CmsDomainException e) {
            Page page = new Page(site, LocalizedString.fromJson((JsonElement)jsonObject.get("name")));
            page.setSlug(jsonObject.get("slug").getAsString());
            page.setCanViewGroup(Group.parse((String)jsonObject.get("canViewGroup").getAsString()));
            if (jsonObject.has("templateType") && !jsonObject.get("templateType").isJsonNull()) {
                page.setTemplateType(jsonObject.get("templateType").getAsString());
            }
            page.setPublished(jsonObject.get("published").getAsBoolean());
            for (JsonElement el : jsonObject.get("components").getAsJsonArray()) {
                Component component = this.importComponent(el.getAsJsonObject());
                if (component == null) continue;
                page.addComponents(component);
            }
            return page;
        }
    }

    private Component importComponent(JsonObject jsonObject) {
        Component component = null;
        try {
            ComponentDescriptor descriptor = Component.forType(jsonObject.get("type").getAsString());
            component = descriptor != null && !descriptor.isStateless() ? descriptor.fromJson(jsonObject) : Component.forType(descriptor.getType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return component;
    }

    private Menu importMenu(Site site, String menuSlug, JsonObject jsonObject) {
        return Optional.ofNullable(site.menuForSlug(menuSlug)).orElseGet(() -> {
            Menu menu = new Menu(site, LocalizedString.fromJson((JsonElement)jsonObject.get("name")));
            menu.setSlug(jsonObject.get("slug").getAsString());
            for (JsonElement childrenEl : jsonObject.get("topLevelItems").getAsJsonArray()) {
                this.importMenuItem(site, menu, null, childrenEl.getAsJsonObject());
            }
            return menu;
        });
    }

    private MenuItem importMenuItem(Site site, Menu menu, MenuItem parent, JsonObject jsonObject) {
        MenuItem menuItem = new MenuItem(menu);
        menuItem.setName(LocalizedString.fromJson((JsonElement)jsonObject.get("name")));
        menuItem.setPosition(jsonObject.get("position").getAsInt());
        menuItem.setFolder(jsonObject.get("isFolder").getAsBoolean());
        if (jsonObject.has("top") && !jsonObject.get("top").isJsonNull() && menu != null) {
            menuItem.setTop(menu);
        }
        if (jsonObject.has("parent") && !jsonObject.get("parent").isJsonNull() && parent != null) {
            menuItem.setParent(parent);
        }
        if (jsonObject.has("page")) {
            menuItem.setPage(site.pageForSlug(jsonObject.get("page").getAsString()));
        }
        for (JsonElement childrenEl : jsonObject.get("children").getAsJsonArray()) {
            this.importMenuItem(site, menu, menuItem, childrenEl.getAsJsonObject());
        }
        return menuItem;
    }

    private Post importPost(Site site, String postSlug, JsonObject jsonObject) {
        return Optional.ofNullable(site.postForSlug(postSlug)).orElseGet(() -> {
            Post post = new Post(site);
            LocalizedString body = LocalizedString.fromJson((JsonElement)jsonObject.get("body"));
            LocalizedString excerpt = jsonObject.has("excerpt") ? LocalizedString.fromJson((JsonElement)jsonObject.get("excerpt")) : null;
            post.setName(LocalizedString.fromJson((JsonElement)jsonObject.get("name")));
            post.setSlug(jsonObject.get("slug").getAsString());
            post.setCanViewGroup(Group.parse((String)jsonObject.get("canViewGroup").getAsString()));
            post.setActive(jsonObject.get("active").getAsBoolean());
            if (jsonObject.has("location") && jsonObject.get("location").isJsonObject()) {
                post.setLocation(LocalizedString.fromJson((JsonElement)jsonObject.get("location")));
            }
            if (jsonObject.has("metadata") && jsonObject.get("metadata").isJsonObject()) {
                post.setMetadata(PostMetadata.fromJson(jsonObject.get("metadata")));
            }
            if (jsonObject.has("publicationBegin") && jsonObject.get("publicationBegin").isJsonPrimitive()) {
                post.setPublicationBegin(DateTime.parse((String)jsonObject.get("publicationBegin").getAsString()));
            }
            if (jsonObject.has("publicationEnd") && jsonObject.get("publicationEnd").isJsonPrimitive()) {
                post.setPublicationEnd(DateTime.parse((String)jsonObject.get("publicationEnd").getAsString()));
            }
            if (jsonObject.has("categories") && jsonObject.get("categories").isJsonArray()) {
                for (JsonElement catSlug : jsonObject.get("categories").getAsJsonArray()) {
                    post.addCategories(site.categoryForSlug(catSlug.getAsString()));
                }
            }
            for (JsonElement postFileEl : jsonObject.get("files").getAsJsonArray()) {
                JsonObject postFileJson = postFileEl.getAsJsonObject();
                try {
                    InputStream inputStream = this.getZipFile().getInputStream(this.getZipFile().getEntry(FilenameUtils.normalize((String)("files/" + postFileJson.get("file").getAsString()))));
                    GroupBasedFile file = new GroupBasedFile(postFileJson.get("displayName").getAsString(), postFileJson.get("fileName").getAsString(), inputStream, Group.parse((String)postFileJson.get("viewGroup").getAsString()));
                    new PostFile(post, file, postFileJson.get("isEmbedded").getAsBoolean(), postFileJson.get("index").getAsInt());
                    body = this.replace(body, postFileJson.get("url").getAsString(), FileDownloadServlet.getDownloadUrl((GenericFile)file));
                    excerpt = this.replace(excerpt, postFileJson.get("url").getAsString(), FileDownloadServlet.getDownloadUrl((GenericFile)file));
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to import file " + postFileJson.get("url").getAsString());
                }
            }
            post.setBodyAndExcerpt(body, excerpt);
            return post;
        });
    }

    private LocalizedString replace(LocalizedString localized, String origContent, String newContent) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : localized.getLocales()) {
            result = result.with(locale, localized.getContent(locale).replace(origContent, newContent));
        }
        return result;
    }

    private Category importCategory(Site site, String categorySlug, JsonObject jsonObject) {
        Category category = site.getOrCreateCategoryForSlug(categorySlug, LocalizedString.fromJson((JsonElement)jsonObject.get("name")));
        for (JsonElement el : jsonObject.get("components").getAsJsonArray()) {
            Component component = this.importComponent(el.getAsJsonObject());
            if (component == null || !ListCategoryPosts.class.isInstance(component)) continue;
            category.addComponents((ListCategoryPosts)((Object)component));
        }
        System.out.println("importCategory - result: " + category);
        return category;
    }

    private JsonObject getSiteJson() {
        return this.getZipEntries("site.json");
    }

    private JsonObject getZipEntries(String fileName) {
        try {
            InputStreamReader reader = new InputStreamReader(this.getZipFile().getInputStream(this.getZipFile().getEntry(fileName)));
            JsonObject jsonObject = new JsonParser().parse((Reader)reader).getAsJsonObject();
            ((Reader)reader).close();
            return jsonObject;
        }
        catch (IOException e) {
            return new JsonObject();
        }
    }

    private Map<String, JsonObject> readJsonDirectory(String dirName) {
        HashMap directoryEntries = Maps.newHashMap();
        Enumeration<? extends ZipEntry> zipEntries = this.getZipFile().entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            if (entry.isDirectory() || !entry.getName().startsWith(dirName) || !entry.getName().endsWith(".json")) continue;
            try {
                JsonObject json = PARSER.parse((Reader)new InputStreamReader(this.getZipFile().getInputStream(entry))).getAsJsonObject();
                String entryName = entry.getName().substring(dirName.length(), entry.getName().lastIndexOf(".json"));
                directoryEntries.put(entryName, json);
            }
            catch (IOException iOException) {}
        }
        return directoryEntries;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    static {
        advice$importSite = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        PARSER = new JsonParser();
    }
}

