/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.cms.domain.CmsSettings;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.cms.domain.Role;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.exceptions.CmsDomainException;

public class PermissionEvaluation {
    public static boolean canAccess(User user, Site site) {
        return CmsSettings.getInstance().canManageSettings() || site.getRolesSet().stream().filter(x -> x.getGroup().isMember(user)).findAny().isPresent();
    }

    public static boolean canDoThis(User user, Site site, PermissionsArray.Permission ... permissions) {
        HashSet requiredPerms = Sets.newHashSet((Object[])permissions);
        if (CmsSettings.getInstance().canManageSettings()) {
            return true;
        }
        for (Role role : site.getRolesSet()) {
            EnumSet<PermissionsArray.Permission> availablePerms = role.getRoleTemplate().getPermissions().get();
            Sets.SetView intersection = Sets.intersection(availablePerms, (Set)requiredPerms);
            if (intersection.isEmpty() || !role.getGroup().isMember(user)) continue;
            requiredPerms.removeAll((Collection<?>)intersection);
        }
        return requiredPerms.isEmpty();
    }

    public static boolean canDoThis(Site site, String permissions) {
        return PermissionEvaluation.canDoThis(site, (PermissionsArray.Permission[])Stream.of(permissions.split(",")).map(String::trim).map(PermissionsArray.Permission::valueOf).toArray(PermissionsArray.Permission[]::new));
    }

    public static boolean canDoThis(Site site, PermissionsArray.Permission ... permissions) {
        return PermissionEvaluation.canDoThis(Authenticate.getUser(), site, permissions);
    }

    public static void ensureCanDoThis(User user, Site site, PermissionsArray.Permission ... permissions) {
        if (!PermissionEvaluation.canDoThis(user, site, permissions)) {
            throw CmsDomainException.forbiden();
        }
    }

    public static void ensureCanDoThis(Site site, PermissionsArray.Permission ... permissions) {
        PermissionEvaluation.ensureCanDoThis(Authenticate.getUser(), site, permissions);
    }

    private static void ensureCanAccess(User user, Site site) {
        if (!PermissionEvaluation.canAccess(user, site)) {
            throw CmsDomainException.forbiden();
        }
    }

    public static void ensureCanAccess(Site site) {
        PermissionEvaluation.ensureCanAccess(Authenticate.getUser(), site);
    }
}

