/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.api.json.DateTimeViewer;
import org.fenixedu.bennu.core.api.json.LocalizedStringViewer;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.cms.domain.MenuItem;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.DomainObject;

@DefaultJsonAdapter(value=MenuItem.class)
public class MenuItemAdapter
implements JsonAdapter<MenuItem> {
    public MenuItem create(JsonElement arg0, JsonBuilder arg1) {
        return null;
    }

    public MenuItem update(JsonElement json, MenuItem menuItem, JsonBuilder ctx) {
        PermissionEvaluation.ensureCanDoThis(menuItem.getMenu().getSite(), PermissionsArray.Permission.LIST_MENUS, PermissionsArray.Permission.EDIT_MENU, PermissionsArray.Permission.EDIT_MENU_ITEM);
        JsonObject jObj = json.getAsJsonObject();
        if (jObj.has("position") && !jObj.get("position").isJsonNull()) {
            menuItem.setPosition(jObj.get("position").getAsInt());
        }
        if (jObj.has("name") && !jObj.get("name").isJsonNull() && jObj.get("name").isJsonObject()) {
            menuItem.setName(LocalizedString.fromJson((JsonElement)jObj.get("name")));
        }
        if (jObj.has("url") && !jObj.get("url").isJsonNull()) {
            menuItem.setUrl(jObj.get("url").getAsString());
        }
        if (jObj.has("folder") && !jObj.get("folder").isJsonNull()) {
            menuItem.setFolder(jObj.get("folder").getAsBoolean());
        }
        Signal.emit((String)"fenixedu.cms.menuItem.edited", (Object)new DomainObjectEvent((DomainObject)menuItem));
        return menuItem;
    }

    public JsonElement view(MenuItem menuItem, JsonBuilder ctx) {
        PermissionEvaluation.ensureCanDoThis(menuItem.getMenu().getSite(), PermissionsArray.Permission.LIST_MENUS);
        JsonObject json = new JsonObject();
        json.addProperty("id", menuItem.getExternalId());
        json.add("name", ctx.view((Object)menuItem.getName(), LocalizedStringViewer.class));
        json.add("creationDate", ctx.view((Object)menuItem.getCreationDate(), DateTimeViewer.class));
        json.addProperty("position", (Number)menuItem.getPosition());
        json.addProperty("url", menuItem.getUrl());
        json.addProperty("folder", Boolean.valueOf(menuItem.getFolder()));
        if (menuItem.getCreatedBy() != null) {
            json.addProperty("createdBy", menuItem.getCreatedBy().getUsername());
        }
        if (menuItem.getMenu() != null) {
            json.addProperty("menu", menuItem.getMenu().getExternalId());
        }
        JsonArray items = new JsonArray();
        menuItem.getChildrenSet().stream().forEach(item -> {
            JsonObject jItem = new JsonObject();
            jItem.addProperty("id", item.getExternalId());
            items.add((JsonElement)jItem);
        });
        json.add("menuItems", (JsonElement)items);
        return json;
    }
}

