/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import java.util.Locale;
import org.fenixedu.commons.i18n.LocalizedString;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public class Sanitization {
    private static PolicyFactory CMS_SANITIZER = new HtmlPolicyBuilder().allowStyling().allowStandardUrlProtocols().allowElements(new String[]{"a", "b", "blockquote", "br", "caption", "cite", "code", "col", "colgroup", "dd", "dl", "dt", "em", "h1", "h2", "h3", "h4", "h5", "h6", "i", "iframe", "img", "li", "ol", "p", "pre", "q", "small", "strike", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "u", "ul", "div", "font", "span"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"title"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"cite"}).onElements(new String[]{"blockquote"}).allowAttributes(new String[]{"span"}).onElements(new String[]{"col"}).allowAttributes(new String[]{"width"}).onElements(new String[]{"col"}).allowAttributes(new String[]{"span"}).onElements(new String[]{"colgroup"}).allowAttributes(new String[]{"width"}).onElements(new String[]{"colgroup"}).allowAttributes(new String[]{"align"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"alt"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"height"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"src"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"title"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"width"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"start"}).onElements(new String[]{"ol"}).allowAttributes(new String[]{"type"}).onElements(new String[]{"ol"}).allowAttributes(new String[]{"cite"}).onElements(new String[]{"q"}).allowAttributes(new String[]{"summary"}).onElements(new String[]{"table"}).allowAttributes(new String[]{"width"}).onElements(new String[]{"table"}).allowAttributes(new String[]{"abbr"}).onElements(new String[]{"td"}).allowAttributes(new String[]{"axis"}).onElements(new String[]{"td"}).allowAttributes(new String[]{"colspan"}).onElements(new String[]{"td"}).allowAttributes(new String[]{"rowspan"}).onElements(new String[]{"td"}).allowAttributes(new String[]{"width"}).onElements(new String[]{"td"}).allowAttributes(new String[]{"abbr"}).onElements(new String[]{"th"}).allowAttributes(new String[]{"axis"}).onElements(new String[]{"th"}).allowAttributes(new String[]{"colspan"}).onElements(new String[]{"th"}).allowAttributes(new String[]{"rowspan"}).onElements(new String[]{"th"}).allowAttributes(new String[]{"scope"}).onElements(new String[]{"th"}).allowAttributes(new String[]{"width"}).onElements(new String[]{"th"}).allowAttributes(new String[]{"type"}).onElements(new String[]{"ul"}).allowAttributes(new String[]{"class", "color"}).onElements(new String[]{"font"}).allowAttributes(new String[]{"width", "height", "src", "allow", "allowfullscreen"}).onElements(new String[]{"iframe"}).allowAttributes(new String[]{"color", "face", "size"}).globally().toFactory();
    private static PolicyFactory STRICT_SANITIZER = new HtmlPolicyBuilder().toFactory();

    public static LocalizedString sanitize(LocalizedString origin) {
        LocalizedString result = new LocalizedString();
        for (Locale l : origin.getLocales()) {
            result = result.with(l, Sanitization.sanitize(origin.getContent(l)));
        }
        return result;
    }

    public static LocalizedString strictSanitize(LocalizedString origin) {
        LocalizedString result = new LocalizedString();
        for (Locale l : origin.getLocales()) {
            result = result.with(l, Sanitization.strictSanitize(origin.getContent(l)));
        }
        return result;
    }

    public static String sanitize(String original) {
        return CMS_SANITIZER.sanitize(original);
    }

    public static String strictSanitize(String original) {
        return STRICT_SANITIZER.sanitize(original);
    }
}

