/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.api.json.DateTimeViewer;
import org.fenixedu.bennu.core.api.json.LocalizedStringViewer;
import org.fenixedu.bennu.core.domain.exceptions.BennuCoreDomainException;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.cms.domain.CMSFolder;
import org.fenixedu.cms.domain.CMSTheme;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

@DefaultJsonAdapter(value=Site.class)
public class SiteAdapter
implements JsonAdapter<Site> {
    public Site create(JsonElement json, JsonBuilder ctx) {
        JsonObject jObj = json.getAsJsonObject();
        JsonElement name = this.getRequiredValue(jObj, "name");
        JsonElement description = this.getRequiredValue(jObj, "description");
        Site site = new Site(LocalizedString.fromJson((JsonElement)name), LocalizedString.fromJson((JsonElement)description));
        if (jObj.has("theme") && !jObj.get("theme").isJsonNull()) {
            site.setTheme((CMSTheme)FenixFramework.getDomainObject((String)jObj.get("theme").getAsString()));
        }
        if (jObj.has("embedded") && !jObj.get("embedded").isJsonNull()) {
            site.setEmbedded(jObj.get("embedded").getAsBoolean());
        }
        site.updateMenuFunctionality();
        return site;
    }

    public Site update(JsonElement json, Site site, JsonBuilder ctx) {
        JsonObject jObj = json.getAsJsonObject();
        if (jObj.has("slug") && !jObj.get("slug").isJsonNull()) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.CHOOSE_PATH_AND_FOLDER);
            site.isValidSlug(jObj.get("slug").getAsString());
            site.setSlug(jObj.get("slug").getAsString());
        }
        if (jObj.has("name") && !jObj.get("name").isJsonNull() && jObj.get("name").isJsonObject()) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.EDIT_SITE_INFORMATION);
            site.setName(LocalizedString.fromJson((JsonElement)jObj.get("name")));
        }
        if (jObj.has("description") && !jObj.get("description").isJsonNull() && jObj.get("description").isJsonObject()) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.EDIT_SITE_INFORMATION);
            site.setDescription(LocalizedString.fromJson((JsonElement)jObj.get("description")));
        }
        if (jObj.has("analyticsCode") && !jObj.get("analyticsCode").isJsonNull()) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.MANAGE_ANALYTICS);
            site.setAnalyticsCode(jObj.get("analyticsCode").getAsString());
        }
        if (jObj.has("folder") && !jObj.get("folder").isJsonNull()) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.CHOOSE_PATH_AND_FOLDER);
            site.setFolder((CMSFolder)FenixFramework.getDomainObject((String)jObj.get("folder").getAsString()));
        }
        if (jObj.has("theme") && !jObj.get("theme").isJsonNull()) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.CHANGE_THEME);
            site.setTheme((CMSTheme)FenixFramework.getDomainObject((String)jObj.get("theme").getAsString()));
        }
        if (jObj.has("alternativeSite") && !jObj.get("alternativeSite").isJsonNull()) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.EDIT_SITE_INFORMATION);
            site.setAlternativeSite(jObj.get("alternativeSite").getAsString());
        }
        if (jObj.has("published") && !jObj.get("published").isJsonNull()) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.PUBLISH_SITE);
            site.setPublished(jObj.get("published").getAsBoolean());
        }
        Signal.emit((String)"fenixedu.cms.site.edited", (Object)new DomainObjectEvent((DomainObject)site));
        return site;
    }

    public JsonElement view(Site site, JsonBuilder ctx) {
        JsonObject json = new JsonObject();
        json.addProperty("id", site.getExternalId());
        json.addProperty("slug", site.getSlug());
        json.add("name", ctx.view((Object)site.getName(), LocalizedStringViewer.class));
        json.add("description", ctx.view((Object)site.getDescription(), LocalizedStringViewer.class));
        json.addProperty("alternativeSite", site.getAlternativeSite());
        json.add("creationDate", ctx.view((Object)site.getCreationDate(), DateTimeViewer.class));
        json.addProperty("published", Boolean.valueOf(site.getPublished()));
        json.addProperty("embedded", Boolean.valueOf(site.getEmbedded()));
        json.addProperty("analyticsCode", site.getAnalyticsCode());
        if (site.getTheme() != null) {
            json.addProperty("theme", site.getTheme().getExternalId());
        }
        if (site.getCreatedBy() != null) {
            json.addProperty("createdBy", site.getCreatedBy().getUsername());
        }
        return json;
    }

    protected JsonElement getRequiredValue(JsonObject obj, String property) {
        if (obj.has(property)) {
            return obj.get(property);
        }
        throw BennuCoreDomainException.cannotCreateEntity();
    }
}

