/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.rss;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.core.Project;
import pt.ist.fenixframework.core.exception.ProjectException;

public class RSSService {
    private static final String CMS_VERSION = RSSService.getCMSVersion();
    private static final Pattern sanitizeInputForXml = Pattern.compile("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD\ud800\udc00-\udbff\udfff]");

    public static String generateRSSForSite(Site site, Locale locale) throws XMLStreamException {
        return RSSService.generateRSS(site.getRssUrl(), site.getFullUrl(), RSSService.contentOf(site.getName(), locale), RSSService.contentOf(site.getDescription(), locale), locale, site.getPostSet());
    }

    public static String generateRSSForCategory(Category category, Locale locale) throws XMLStreamException {
        String title = RSSService.contentOf(category.getName(), locale) + " \u00b7 " + RSSService.contentOf(category.getSite().getName(), locale);
        return RSSService.generateRSS(category.getRssUrl(), category.getAddress(), title, title, locale, category.getPostsSet());
    }

    private static String generateRSS(String rssUrl, String url, String title, String description, Locale locale, Collection<Post> posts) throws XMLStreamException {
        StringWriter strWriter = new StringWriter();
        XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(strWriter);
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        Characters nl = eventFactory.createCharacters("\n");
        writer.add(eventFactory.createStartDocument());
        writer.add(nl);
        writer.add(eventFactory.createStartElement("", "", "rss"));
        writer.add(eventFactory.createAttribute("version", "2.0"));
        writer.add(eventFactory.createAttribute("xmlns:atom", "http://www.w3.org/2005/Atom"));
        writer.add(nl);
        writer.add(eventFactory.createStartElement("", "", "channel"));
        writer.add(nl);
        writer.add(eventFactory.createCharacters("\t"));
        writer.add(eventFactory.createStartElement("", "", "atom:link"));
        writer.add(eventFactory.createAttribute("rel", "self"));
        writer.add(eventFactory.createAttribute("type", "application/rss+xml"));
        writer.add(eventFactory.createAttribute("href", rssUrl));
        writer.add(eventFactory.createEndElement("", "", "atom:link"));
        writer.add(nl);
        RSSService.createNode(writer, eventFactory, "title", title);
        RSSService.createNode(writer, eventFactory, "link", url);
        RSSService.createNode(writer, eventFactory, "description", description);
        RSSService.createNode(writer, eventFactory, "language", locale.toLanguageTag());
        RSSService.createNode(writer, eventFactory, "copyright", RSSService.contentOf(PortalConfiguration.getInstance().getApplicationCopyright(), locale));
        RSSService.createNode(writer, eventFactory, "webMaster", PortalConfiguration.getInstance().getSupportEmailAddress() + " (" + RSSService.contentOf(PortalConfiguration.getInstance().getApplicationTitle(), locale) + ")");
        RSSService.createNode(writer, eventFactory, "generator", "FenixEdu CMS " + CMS_VERSION);
        RSSService.createNode(writer, eventFactory, "docs", "http://blogs.law.harvard.edu/tech/rss");
        RSSService.createNode(writer, eventFactory, "ttl", "60");
        writer.add(nl);
        for (Post post : posts) {
            if (!post.isVisible() || !post.getCanViewGroup().isMember(null)) continue;
            RSSService.writePost(locale, writer, post, eventFactory);
        }
        writer.add(eventFactory.createEndElement("", "", "channel"));
        writer.add(nl);
        writer.add(eventFactory.createEndElement("", "", "rss"));
        writer.add(nl);
        writer.add(eventFactory.createEndDocument());
        writer.close();
        return strWriter.toString();
    }

    private static void writePost(Locale locale, XMLEventWriter writer, Post post, XMLEventFactory eventFactory) throws XMLStreamException {
        writer.add(eventFactory.createStartElement("", "", "item"));
        writer.add(eventFactory.createCharacters("\n"));
        RSSService.createNode(writer, eventFactory, "title", sanitizeInputForXml.matcher(RSSService.contentOf(post.getName(), locale)).replaceAll(""));
        RSSService.createNode(writer, eventFactory, "description", sanitizeInputForXml.matcher(RSSService.contentOf(post.getBody(), locale)).replaceAll(""));
        RSSService.createNode(writer, eventFactory, "link", post.getAddress());
        boolean hasEmail = post.getCreatedBy().getProfile() != null && post.getCreatedBy().getProfile().getEmail() != null;
        String authorEmail = hasEmail ? post.getCreatedBy().getProfile().getEmail() : "";
        RSSService.createNode(writer, eventFactory, "author", authorEmail + " (" + post.getCreatedBy().getProfile().getDisplayName() + ")");
        RSSService.createNode(writer, eventFactory, "guid", post.getAddress() + "#" + post.getExternalId());
        if (!post.getCategoriesSet().isEmpty()) {
            RSSService.createNode(writer, eventFactory, "category", post.getCategoriesSet().stream().map(cat -> RSSService.contentOf(cat.getName(), locale)).collect(Collectors.joining("/")));
        }
        RSSService.createNode(writer, eventFactory, "pubDate", post.getCreationDate().toString("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH));
        writer.add(eventFactory.createCharacters("\n"));
        writer.add(eventFactory.createEndElement("", "", "item"));
        writer.add(eventFactory.createCharacters("\n"));
    }

    private static String getCMSVersion() {
        try {
            Project project = Project.fromName((String)"fenixedu-cms");
            return project == null ? "" : "v" + project.getVersion();
        }
        catch (IOException | ProjectException e) {
            return "";
        }
    }

    private static void createNode(XMLEventWriter eventWriter, XMLEventFactory eventFactory, String name, String value) throws XMLStreamException {
        eventWriter.add(eventFactory.createCharacters("\t"));
        eventWriter.add(eventFactory.createStartElement("", "", name));
        eventWriter.add(eventFactory.createCharacters(value == null ? "" : value));
        eventWriter.add(eventFactory.createEndElement("", "", name));
        eventWriter.add(eventFactory.createCharacters("\n"));
    }

    private static String contentOf(LocalizedString localizedString, Locale locale) {
        return Optional.ofNullable(Optional.ofNullable(localizedString.getContent(locale)).orElse(localizedString.getContent())).orElse("");
    }
}

