/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.ui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Writer;
import java.util.HashMap;
import java.util.function.BiConsumer;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.cms.domain.SiteActivity;
import org.fenixedu.commons.i18n.LocalizedString;

public class SiteActivityRender {
    private static HashMap<String, BiConsumer<SiteActivity, Writer>> map = new HashMap();

    public static void render(SiteActivity activity, Writer writer) {
        BiConsumer<SiteActivity, Writer> consumer;
        JsonElement el = activity.getContent();
        String type = el.getAsJsonObject().get("type").getAsString();
        if (type != null && (consumer = map.get(type)) != null) {
            consumer.accept(activity, writer);
        }
    }

    public static void attachRenderer(String type, BiConsumer<SiteActivity, Writer> consumer) {
        map.put(type, consumer);
    }

    public static void init() {
        SiteActivityRender.attachRenderer("siteCreated", SiteActivityRender::siteCreated);
        SiteActivityRender.attachRenderer("postCreated", SiteActivityRender::postCreated);
        SiteActivityRender.attachRenderer("postEdited", SiteActivityRender::postEdited);
        SiteActivityRender.attachRenderer("postDeleted", SiteActivityRender::postDeleted);
        SiteActivityRender.attachRenderer("postRecovered", SiteActivityRender::postRecovered);
        SiteActivityRender.attachRenderer("siteImported", SiteActivityRender::siteImported);
        SiteActivityRender.attachRenderer("siteCloned", SiteActivityRender::siteCloned);
        SiteActivityRender.attachRenderer("pageCreated", SiteActivityRender::pageCreated);
        SiteActivityRender.attachRenderer("pageEdited", SiteActivityRender::pageEdited);
        SiteActivityRender.attachRenderer("pageDeleted", SiteActivityRender::pageDeleted);
        SiteActivityRender.attachRenderer("pageRecovered", SiteActivityRender::pageRecovered);
    }

    private static void siteImported(SiteActivity activity, Writer writer) {
        JsonElement el = activity.getContent();
        JsonObject obj = el.getAsJsonObject();
        String postName = LocalizedString.fromJson((JsonElement)obj.get("siteName")).getContent();
        SiteActivityRender.write(writer, obj.get("user").getAsString(), "imported", postName);
    }

    private static void siteCloned(SiteActivity activity, Writer writer) {
        JsonElement el = activity.getContent();
        JsonObject obj = el.getAsJsonObject();
        String postName = LocalizedString.fromJson((JsonElement)obj.get("siteName")).getContent();
        SiteActivityRender.write(writer, obj.get("user").getAsString(), "cloned", postName);
    }

    private static void siteCreated(SiteActivity activity, Writer writer) {
        JsonElement el = activity.getContent();
        JsonObject obj = el.getAsJsonObject();
        String postName = LocalizedString.fromJson((JsonElement)obj.get("siteName")).getContent();
        SiteActivityRender.write(writer, obj.get("user").getAsString(), "created", postName);
    }

    private static void postCreated(SiteActivity activity, Writer writer) {
        JsonElement el = activity.getContent();
        JsonObject obj = el.getAsJsonObject();
        String postName = LocalizedString.fromJson((JsonElement)obj.get("postName")).getContent();
        SiteActivityRender.write(writer, obj.get("user").getAsString(), "created", postName);
    }

    private static void postEdited(SiteActivity activity, Writer writer) {
        JsonElement el = activity.getContent();
        JsonObject obj = el.getAsJsonObject();
        String postName = LocalizedString.fromJson((JsonElement)obj.get("postName")).getContent();
        SiteActivityRender.write(writer, obj.get("user").getAsString(), "edited", postName);
    }

    private static void postDeleted(SiteActivity activity, Writer writer) {
        JsonElement el = activity.getContent();
        JsonObject obj = el.getAsJsonObject();
        String postName = LocalizedString.fromJson((JsonElement)obj.get("postName")).getContent();
        SiteActivityRender.write(writer, obj.get("user").getAsString(), "deleted", postName);
    }

    private static void postRecovered(SiteActivity activity, Writer writer) {
        JsonElement el = activity.getContent();
        JsonObject obj = el.getAsJsonObject();
        String postName = LocalizedString.fromJson((JsonElement)obj.get("postName")).getContent();
        SiteActivityRender.write(writer, obj.get("user").getAsString(), "recovered", postName);
    }

    private static void pageCreated(SiteActivity activity, Writer writer) {
        JsonElement el = activity.getContent();
        JsonObject obj = el.getAsJsonObject();
        String postName = LocalizedString.fromJson((JsonElement)obj.get("pageName")).getContent();
        SiteActivityRender.write(writer, obj.get("user").getAsString(), "created", postName);
    }

    private static void pageEdited(SiteActivity activity, Writer writer) {
        JsonElement el = activity.getContent();
        JsonObject obj = el.getAsJsonObject();
        String postName = LocalizedString.fromJson((JsonElement)obj.get("pageName")).getContent();
        SiteActivityRender.write(writer, obj.get("user").getAsString(), "edited", postName);
    }

    private static void pageDeleted(SiteActivity activity, Writer writer) {
        JsonElement el = activity.getContent();
        JsonObject obj = el.getAsJsonObject();
        String postName = LocalizedString.fromJson((JsonElement)obj.get("pageName")).getContent();
        SiteActivityRender.write(writer, obj.get("user").getAsString(), "deleted", postName);
    }

    private static void pageRecovered(SiteActivity activity, Writer writer) {
        JsonElement el = activity.getContent();
        JsonObject obj = el.getAsJsonObject();
        String pageName = LocalizedString.fromJson((JsonElement)obj.get("pageName")).getContent();
        SiteActivityRender.write(writer, obj.get("user").getAsString(), "recovered", pageName);
    }

    private static void write(Writer writer, String username, String action, String content) {
        try {
            User user = User.findByUsername((String)username);
            writer.write("<a href='#' class='avatar'><img src='" + user.getProfile().getFullAvatarUrl() + "?s=32' alt='" + user.getProfile().getDisplayName() + "' /></a>");
            writer.write("<p><strong>" + user.getProfile().getDisplayName() + "</strong> " + action + " " + content + " </p>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        SiteActivityRender.init();
    }
}

