/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupArgumentParser;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.groups.ArgumentParser;
import org.fenixedu.bennu.core.groups.CustomGroup;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.cms.domain.Site;
import org.joda.time.DateTime;

@GroupOperator(value="siteViewers")
public class SiteViewersGroup
extends CustomGroup {
    private static final long serialVersionUID = -2690871317679895561L;
    @GroupArgument(value="")
    private final Site site;

    private SiteViewersGroup() {
        this.site = null;
    }

    private SiteViewersGroup(Site site) {
        this.site = site;
    }

    public static Group get(Site site) {
        return new SiteViewersGroup(Objects.requireNonNull(site));
    }

    public String getPresentationName() {
        return "Site Viewers for site: " + this.site;
    }

    public PersistentGroup toPersistentGroup() {
        return this.site.getViewerGroup();
    }

    public Stream<User> getMembers() {
        if (!this.site.getPublished()) {
            return Stream.empty();
        }
        return this.site.getCanViewGroup().getMembers();
    }

    public Stream<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (Optional.ofNullable(this.site.getPublished()).orElse(false).booleanValue()) {
            return this.site.getCanViewGroup().isMember(user);
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public boolean equals(Object object) {
        if (object instanceof SiteViewersGroup) {
            SiteViewersGroup other = (SiteViewersGroup)((Object)object);
            return this.site.equals(other.site);
        }
        return false;
    }

    public int hashCode() {
        return this.site.hashCode();
    }

    @GroupArgumentParser
    public static final class SiteArgumentParser
    implements ArgumentParser<Site> {
        public Site parse(String argument) {
            return Site.fromSlug(argument);
        }

        public String serialize(Site argument) {
            return argument.getSlug();
        }

        public Class<Site> type() {
            return Site.class;
        }
    }
}

