/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.cms.domain.Role;
import org.fenixedu.cms.domain.RoleTemplate;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.SiteActivity;
import org.fenixedu.cms.domain.SiteBuilder_Base;
import org.fenixedu.cms.domain.SlugUtils;
import org.fenixedu.cms.domain.Sluggable;
import org.fenixedu.commons.i18n.LocalizedString;

public class SiteBuilder
extends SiteBuilder_Base
implements Sluggable {
    public SiteBuilder(String slug) {
        this();
        this.setSlug(SlugUtils.makeSlug(this, slug));
    }

    public SiteBuilder() {
        Bennu.getInstance().getSiteBuildersSet().add(this);
        this.setCanViewGroup(Group.nobody());
    }

    public Site create(LocalizedString name, LocalizedString description) {
        Site site = new Site(name, description);
        site.setBuilder(this);
        site.setTheme(this.getTheme());
        site.setCanViewGroup(this.getCanViewGroup());
        site.setPublished(this.getPublished());
        site.setEmbedded(this.getEmbedded());
        for (RoleTemplate roleTemplate : this.getRoleTemplateSet()) {
            new Role(roleTemplate, site);
        }
        site.setFolder(this.getFolder());
        this.getCategoriesSet().stream().forEach(category -> site.categoryForSlug(category.getSlug()));
        site.updateMenuFunctionality();
        SiteActivity.createdSite(site, Authenticate.getUser());
        return site;
    }

    public boolean isSystemBuilder() {
        return false;
    }

    public Group getCanViewGroup() {
        return this.getViewGroup().toGroup();
    }

    public void setCanViewGroup(Group group) {
        this.setViewGroup(group.toPersistentGroup());
    }

    public static final SiteBuilder forSlug(String builderSlug) {
        return Bennu.getInstance().getSiteBuildersSet().stream().filter(sb -> sb.getSlug().equals(builderSlug)).findAny().orElseGet(() -> null);
    }

    @Override
    public void setSlug(String slug) {
        if (this.isValidSlug(slug)) {
            super.setSlug(slug);
        }
    }

    @Override
    public final boolean isValidSlug(String slug) {
        return slug != null && !slug.equals("") && Bennu.getInstance().getSiteBuildersSet().stream().noneMatch(sb -> sb != this && sb.getSlug().equals(slug));
    }

    public void delete() {
        this.setBennu(null);
        this.deleteDomainObject();
    }
}

