/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.routing;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.cms.CMSConfigurationManager;
import org.fenixedu.cms.domain.CMSTheme;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.wraps.UserWrap;
import org.fenixedu.cms.exceptions.ResourceNotFoundException;
import org.fenixedu.cms.rendering.CMSExtensions;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.commons.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSRenderer {
    private static final Logger logger = LoggerFactory.getLogger(CMSRenderer.class);
    private static final Set<RenderingPageHandler> HANDLERS = new HashSet<RenderingPageHandler>();
    private final PebbleEngine engine = new PebbleEngine.Builder().loader((Loader)new ClasspathLoader(){

        public Reader getReader(String templateName) throws LoaderException {
            String[] parts = templateName.split("/", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Not a valid name: " + templateName);
            }
            CMSTheme theme = CMSTheme.forType(parts[0]);
            if (theme == null) {
                throw new IllegalArgumentException("Theme " + parts[0] + " not found!");
            }
            byte[] bytes = theme.contentForPath(parts[1]);
            if (bytes == null) {
                throw new IllegalArgumentException("Theme " + parts[0] + " does not contain resource '" + parts[1] + "\"");
            }
            return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8);
        }
    }).extension(new Extension[]{new CMSExtensions()}).templateCache(CMSConfigurationManager.isInThemeDevelopmentMode() ? null : CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build()).build();

    public CMSRenderer() {
        if (CMSConfigurationManager.isInThemeDevelopmentMode()) {
            logger.debug("CMS Theme Development Mode enabled!");
        }
    }

    void renderCMSPage(HttpServletRequest req, HttpServletResponse res, Site sites, String pageSlug) throws ServletException, IOException, PebbleException {
        String[] parts;
        String pageName;
        Page page;
        if (pageSlug.startsWith("/")) {
            pageSlug = pageSlug.substring(1);
        }
        if ((page = Strings.isNullOrEmpty((String)(pageName = (parts = pageSlug.split("/"))[0])) && sites.getInitialPage() != null ? sites.getInitialPage() : (Page)sites.getPagesSet().stream().filter(p -> pageName.equals(p.getSlug())).findAny().orElse(null)) == null || page.getTemplate() == null) {
            this.errorPage(req, res, sites, 404);
        } else if (!page.getPublished() || !page.getCanViewGroup().isMember(Authenticate.getUser())) {
            if (Authenticate.isLogged()) {
                this.errorPage(req, res, sites, 403);
            } else {
                this.errorPage(req, res, sites, 401);
            }
        } else {
            try {
                this.renderPage(req, pageSlug, res, sites, page, parts);
            }
            catch (ResourceNotFoundException e) {
                this.errorPage(req, res, sites, 404);
            }
        }
    }

    private void renderPage(HttpServletRequest req, String reqPagePath, HttpServletResponse res, Site site, Page page, String[] requestContext) throws PebbleException, IOException {
        TemplateContext global = new TemplateContext();
        global.setRequestContext(requestContext);
        for (Iterator<RenderingPageHandler> key : req.getParameterMap().keySet()) {
            global.put(key, req.getParameter((String)((Object)key)));
        }
        global.put("page", this.makePageWrapper(page));
        this.populateSiteInfo(req, page, site, global);
        ArrayList<TemplateContext> components = new ArrayList<TemplateContext>();
        for (Component component : page.getComponentsSet()) {
            TemplateContext local = new TemplateContext();
            component.handle(page, local, global);
            components.add(local);
        }
        global.put("components", components);
        for (RenderingPageHandler handler : HANDLERS) {
            handler.accept(page, global);
        }
        CMSTheme theme = site.getTheme();
        PebbleTemplate compiledTemplate = this.engine.getTemplate(theme.getType() + "/" + page.getTemplate().getFilePath());
        res.setStatus(200);
        res.setContentType("text/html");
        compiledTemplate.evaluate((Writer)res.getWriter(), (Map)global);
    }

    private void populateSiteInfo(HttpServletRequest req, Page page, Site site, TemplateContext context) {
        context.put("request", this.makeRequestWrapper(req));
        context.put("app", this.makeAppWrapper());
        context.put("site", site.makeWrap());
        context.put("menus", this.makeMenuWrapper(site, page));
        context.put("staticDir", site.getStaticDirectory());
        context.put("devMode", CoreConfiguration.getConfiguration().developmentMode());
    }

    private List<Object> makeMenuWrapper(Site site, Page page) {
        ArrayList result = site.getOrderedMenusSet().stream().map(menu -> page == null ? menu.makeWrap() : menu.makeWrap(page)).collect(Collectors.toCollection(ArrayList::new));
        return result;
    }

    private Map<String, Object> makeAppWrapper() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PortalConfiguration configuration = PortalConfiguration.getInstance();
        result.put("title", configuration.getApplicationTitle());
        result.put("subtitle", configuration.getApplicationSubTitle());
        result.put("copyright", configuration.getApplicationCopyright());
        result.put("support", configuration.getSupportEmailAddress());
        result.put("locale", I18N.getLocale());
        result.put("supportedLocales", CoreConfiguration.supportedLocales());
        return result;
    }

    private Map<String, Object> makePageWrapper(Page page) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", page.getName());
        result.put("user", new UserWrap(page.getCreatedBy()));
        result.put("createdBy", new UserWrap(page.getCreatedBy()));
        result.put("creationDate", page.getCreationDate());
        return result;
    }

    private Map<String, Object> makeRequestWrapper(HttpServletRequest req) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("user", new UserWrap(Authenticate.getUser()));
        result.put("method", req.getMethod());
        result.put("protocol", req.getProtocol());
        result.put("url", CMSRenderer.getFullURL(req));
        result.put("contentType", req.getContentType());
        result.put("contextPath", req.getContextPath());
        return result;
    }

    void errorPage(HttpServletRequest req, HttpServletResponse res, Site site, int errorCode) throws ServletException, IOException {
        CMSTheme cmsTheme = site.getTheme();
        if (cmsTheme != null && cmsTheme.definesPath(errorCode + ".html")) {
            try {
                PebbleTemplate compiledTemplate = this.engine.getTemplate(cmsTheme.getType() + "/" + errorCode + ".html");
                TemplateContext global = new TemplateContext();
                this.populateSiteInfo(req, null, site, global);
                res.setStatus(errorCode);
                res.setContentType("text/html");
                compiledTemplate.evaluate((Writer)res.getWriter(), (Map)global);
            }
            catch (PebbleException e) {
                throw new ServletException("Could not render error page for " + errorCode);
            }
        } else {
            res.sendError(errorCode, req.getRequestURI());
        }
    }

    private static String getFullURL(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            requestURL.append('?').append(queryString);
        }
        return requestURL.toString();
    }

    public void invalidateEntry(String key) {
        this.engine.getTemplateCache().invalidate((Object)key);
    }

    public static void addHandler(RenderingPageHandler handler) {
        HANDLERS.add(handler);
    }

    public static void removeHandler(RenderingPageHandler handler) {
        HANDLERS.remove(handler);
    }

    public static interface RenderingPageHandler
    extends BiConsumer<Page, TemplateContext> {
    }
}

