/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain.component;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.cms.domain.CloneCache;
import org.fenixedu.cms.domain.Cloneable;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.component.CMSComponent;
import org.fenixedu.cms.domain.component.Component$callable$delete;
import org.fenixedu.cms.domain.component.ComponentDescriptor;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.domain.component.Component_Base;
import org.fenixedu.cms.domain.component.StrategyBasedComponent;
import org.fenixedu.cms.exceptions.CmsDomainException;
import org.fenixedu.cms.rendering.TemplateContext;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class Component
extends Component_Base
implements Cloneable {
    protected static final HashMap<String, ComponentDescriptor> COMPONENTS;
    public static final Advice advice$delete;

    public static void register(Class<?> c) {
        COMPONENTS.put(c.getName(), new ComponentDescriptor(c));
    }

    public static ComponentDescriptor forType(String type) {
        return COMPONENTS.get(type);
    }

    public static JsonArray availableComponents(Site site) {
        JsonArray array = new JsonArray();
        COMPONENTS.values().stream().filter(descriptor -> descriptor.isForSite(site)).map(ComponentDescriptor::toJson).forEach(obj -> array.add((JsonElement)obj));
        return array;
    }

    public Component() {
        if (Authenticate.getUser() == null) {
            throw CmsDomainException.forbiden();
        }
        this.setCreatedBy(Authenticate.getUser());
        this.setCreationDate(new DateTime());
    }

    public String getName() {
        return this.componentType().getAnnotation(ComponentType.class).name();
    }

    public String getDescription() {
        return this.componentType().getAnnotation(ComponentType.class).description();
    }

    public String getType() {
        return this.componentType().getName();
    }

    public abstract void handle(Page var1, TemplateContext var2, TemplateContext var3);

    @Override
    public abstract Component clone(CloneCache var1);

    public void delete() {
        Object object = advice$delete.perform((Callable)new Component$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Component this_) {
        this_.setCreatedBy(null);
        for (Page page : this_.getInstalledPageSet()) {
            page.removeComponents(this_);
        }
        this_.deleteDomainObject();
    }

    public Class<?> componentType() {
        return this.getClass();
    }

    public static Component forType(Class<? extends CMSComponent> type) {
        return StrategyBasedComponent.componentForType(type);
    }

    public abstract JsonObject json();

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        COMPONENTS = new HashMap();
    }
}

