/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.api.json.DateTimeViewer;
import org.fenixedu.bennu.core.api.json.LocalizedStringViewer;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.cms.domain.Menu;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.DomainObject;

@DefaultJsonAdapter(value=Menu.class)
public class MenuAdapter
implements JsonAdapter<Menu> {
    public Menu create(JsonElement arg0, JsonBuilder arg1) {
        return null;
    }

    public Menu update(JsonElement json, Menu menu, JsonBuilder ctx) {
        PermissionEvaluation.ensureCanDoThis(menu.getSite(), PermissionsArray.Permission.LIST_MENUS, PermissionsArray.Permission.EDIT_MENU);
        JsonObject jObj = json.getAsJsonObject();
        if (jObj.has("slug") && !jObj.get("slug").isJsonNull()) {
            menu.setSlug(jObj.get("slug").getAsString());
        }
        if (jObj.has("name") && !jObj.get("name").isJsonNull() && jObj.get("name").isJsonObject()) {
            menu.setName(LocalizedString.fromJson((JsonElement)jObj.get("name")));
        }
        Signal.emit((String)"fenixedu.cms.menu.edited", (Object)new DomainObjectEvent((DomainObject)menu));
        return menu;
    }

    public JsonElement view(Menu menu, JsonBuilder ctx) {
        PermissionEvaluation.ensureCanDoThis(menu.getSite(), PermissionsArray.Permission.LIST_MENUS);
        JsonObject json = new JsonObject();
        json.addProperty("id", menu.getExternalId());
        json.addProperty("slug", menu.getSlug());
        json.addProperty("topMenu", Boolean.valueOf(menu.getTopMenu()));
        json.add("creationDate", ctx.view((Object)menu.getCreationDate(), DateTimeViewer.class));
        json.add("name", ctx.view((Object)menu.getName(), LocalizedStringViewer.class));
        if (menu.getCreatedBy() != null) {
            json.addProperty("createdBy", menu.getCreatedBy().getUsername());
        }
        if (menu.getSite() != null) {
            json.addProperty("site", menu.getSite().getExternalId());
        }
        JsonArray items = new JsonArray();
        menu.getToplevelItemsSet().stream().forEach(item -> {
            JsonObject jItem = new JsonObject();
            jItem.addProperty("id", item.getExternalId());
            items.add((JsonElement)jItem);
        });
        json.add("menuItems", (JsonElement)items);
        return json;
    }
}

