/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain.component;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.wraps.Wrap;

public class PostsPresentationBean {
    private static final int FIRST_PAGE_INDEX = 1;
    private final Set<Post> allPosts;

    public PostsPresentationBean(Set<Post> allPosts) {
        this.allPosts = allPosts;
    }

    public HashMap<String, Object> paginate(Page page, int currentPage, int postsPerPage) {
        List pages = Lists.partition(this.getVisiblePosts(), (int)postsPerPage);
        currentPage = this.ensureRange(currentPage, 1, pages.size());
        ArrayList currentPagePosts = pages.isEmpty() ? Lists.newArrayList() : (List)pages.get(currentPage - 1);
        HashMap pagination = Maps.newHashMap();
        pagination.put("pages", this.createPagesList(pages.size()));
        pagination.put("current", currentPage);
        pagination.put("posts", currentPagePosts);
        return pagination;
    }

    private List<Object> createPagesList(int numberOfPages) {
        return IntStream.rangeClosed(1, numberOfPages).mapToObj(i -> ImmutableMap.of((Object)"url", (Object)("?p=" + i), (Object)"number", (Object)i)).collect(Collectors.toList());
    }

    private int ensureRange(int number, int min, int max) {
        return Math.max(Math.min(number, max), min);
    }

    public List<Wrap> getVisiblePosts() {
        return this.visiblePostsStream().collect(Collectors.toList());
    }

    public List<Wrap> getVisiblePosts(long numPosts) {
        return this.visiblePostsStream().limit(numPosts).collect(Collectors.toList());
    }

    private Stream<Wrap> visiblePostsStream() {
        return this.allPosts.stream().filter(p -> p.getComponentSet().isEmpty() && p.isVisible()).sorted(Post.CREATION_DATE_COMPARATOR).map(Wrap::make);
    }

    public int currentPage(String currentPageString) {
        boolean isValid = currentPageString != null && Ints.tryParse((String)currentPageString) != null;
        return isValid ? Ints.tryParse((String)currentPageString) : 1;
    }
}

