/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.fenixedu.cms.domain.CMSThemeFile;

public class CMSThemeFiles {
    private final Map<String, CMSThemeFile> files;
    private final String checksum;

    public CMSThemeFiles(Map<String, CMSThemeFile> files) {
        this.files = ImmutableMap.copyOf(files);
        this.checksum = this.computeChecksum();
    }

    public CMSThemeFiles(byte[] bytes) {
        this.files = this.getMapFromStream(bytes);
        this.checksum = this.computeChecksum();
    }

    private String computeChecksum() {
        StringBuilder builder = new StringBuilder();
        this.files.values().forEach(file -> builder.append(Hashing.sha256().hashBytes(file.getContent()).toString()));
        return Hashing.murmur3_128().hashString((CharSequence)builder, StandardCharsets.UTF_8).toString().substring(0, 16);
    }

    public CMSThemeFile getFileForPath(String path) {
        return this.files.get(path);
    }

    public Collection<CMSThemeFile> getFiles() {
        return this.files.values().stream().sorted(Comparator.comparing(CMSThemeFile::getFileName)).collect(Collectors.toList());
    }

    public JsonArray toJson() {
        JsonArray array = new JsonArray();
        for (CMSThemeFile file : this.files.values()) {
            array.add(file.toJson());
        }
        return array;
    }

    public byte[] externalize() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream stream = new GZIPOutputStream(out);
            stream.write(this.toJson().toString().getBytes(StandardCharsets.UTF_8));
            stream.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not externalize CMSThemeFiles!", e);
        }
    }

    private Map<String, CMSThemeFile> getMapFromStream(byte[] bytes) {
        try {
            GZIPInputStream stream = new GZIPInputStream(new ByteArrayInputStream(bytes));
            byte[] unzipped = ByteStreams.toByteArray((InputStream)stream);
            String json = new String(unzipped, StandardCharsets.UTF_8);
            JsonArray array = new JsonParser().parse(json).getAsJsonArray();
            ImmutableMap.Builder files = ImmutableMap.builder();
            for (JsonElement file : array) {
                CMSThemeFile themeFile = new CMSThemeFile(file.getAsJsonObject());
                files.put((Object)themeFile.getFullPath(), (Object)themeFile);
            }
            return files.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not internalize CMSThemeFiles!", e);
        }
    }

    public CMSThemeFiles with(CMSThemeFile file) {
        HashMap<String, CMSThemeFile> files = new HashMap<String, CMSThemeFile>(this.files);
        files.put(file.getFullPath(), file);
        return new CMSThemeFiles(files);
    }

    public CMSThemeFiles without(String path) {
        HashMap<String, CMSThemeFile> files = new HashMap<String, CMSThemeFile>(this.files);
        files.remove(path);
        return new CMSThemeFiles(files);
    }

    public CMSThemeFiles without(String[] paths) {
        HashMap<String, CMSThemeFile> files = new HashMap<String, CMSThemeFile>(this.files);
        for (String path : paths) {
            files.remove(path);
        }
        return new CMSThemeFiles(files);
    }

    public long getTotalSize() {
        return this.files.values().stream().mapToLong(CMSThemeFile::getFileSize).sum();
    }

    public boolean checksumMatches(CMSThemeFiles files) {
        return this.checksum.equals(files.checksum);
    }

    public String getChecksum() {
        return this.checksum;
    }
}

