/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.resource;

import com.google.gson.JsonElement;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.cms.api.json.MenuItemAdapter;
import org.fenixedu.cms.domain.MenuItem;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;

@Path(value="/cms/menuItems")
public class MenuItemResource
extends BennuRestResource {
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement getMenuItem(@PathParam(value="oid") MenuItem menuItem) {
        return this.view(menuItem, MenuItemAdapter.class);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public Response deleteMenuItem(@PathParam(value="oid") MenuItem menuItem) {
        PermissionEvaluation.ensureCanDoThis(menuItem.getMenu().getSite(), PermissionsArray.Permission.LIST_MENUS, PermissionsArray.Permission.EDIT_MENU, PermissionsArray.Permission.EDIT_MENU_ITEM, PermissionsArray.Permission.DELETE_MENU_ITEM);
        menuItem.delete();
        return Response.ok().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement updateMenuItem(@PathParam(value="oid") MenuItem menuItem, JsonElement json) {
        return this.updateMenuItemFromJson(menuItem, json);
    }

    private JsonElement updateMenuItemFromJson(MenuItem menuItem, JsonElement json) {
        return this.view(this.update(json, menuItem, MenuItemAdapter.class));
    }
}

