/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.StringWriter;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.SiteActivity_Base;
import org.fenixedu.cms.ui.SiteActivityRender;
import org.joda.time.DateTime;

public class SiteActivity
extends SiteActivity_Base {
    public SiteActivity(Site site) {
        this.setSite(site);
    }

    public JsonElement getContent() {
        return new JsonParser().parse(super.getContent().toString());
    }

    protected static void makeActivity(Site site, JsonElement element) {
        SiteActivity activity = new SiteActivity(site);
        activity.setEventDate(new DateTime());
        activity.setContent(element);
        site.pushActivity(activity);
    }

    private static JsonObject siteActivity(Site site, User user, String type) {
        JsonObject object = new JsonObject();
        object.addProperty("type", type);
        object.addProperty("site", site.getExternalId());
        object.add("siteName", site.getName().json());
        object.addProperty("siteSlug", site.getSlug());
        object.addProperty("user", user.getUsername());
        object.addProperty("userName", user.getProfile().getDisplayName());
        SiteActivity.makeActivity(site, (JsonElement)object);
        return object;
    }

    public static void createdSite(Site site, User user) {
        SiteActivity.siteActivity(site, user, "siteCreated");
    }

    public static void clonedSite(Site site, User user) {
        SiteActivity.siteActivity(site, user, "siteCloned");
    }

    public static void importedSite(Site site, User user) {
        SiteActivity.siteActivity(site, user, "siteImported");
    }

    public static void createdPost(Post post, User user) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "postCreated");
        object.addProperty("post", post.getExternalId());
        object.add("postName", post.getName().json());
        object.addProperty("postSlug", post.getSlug());
        object.addProperty("user", user.getUsername());
        object.addProperty("userName", user.getProfile().getDisplayName());
        SiteActivity.makeActivity(post.getSite(), (JsonElement)object);
    }

    public static void editedPost(Post post, User user) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "postEdited");
        object.addProperty("post", post.getExternalId());
        object.add("postName", post.getName().json());
        object.addProperty("postSlug", post.getSlug());
        object.addProperty("user", user.getUsername());
        object.addProperty("userName", user.getProfile().getDisplayName());
        SiteActivity.makeActivity(post.getSite(), (JsonElement)object);
    }

    public static void deletedPost(Post post, Site site, User user) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "postDeleted");
        object.addProperty("post", (String)null);
        object.add("postName", post.getName().json());
        object.addProperty("pageSlug", (String)null);
        object.addProperty("user", user.getUsername());
        object.addProperty("userName", user.getProfile().getDisplayName());
        SiteActivity.makeActivity(site, (JsonElement)object);
    }

    public static void recoveredPost(Post post, Site site, User user) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "postRecovered");
        object.addProperty("post", post.getExternalId());
        object.add("postName", post.getName().json());
        object.addProperty("pageSlug", (String)null);
        object.addProperty("user", user.getUsername());
        object.addProperty("userName", user.getProfile().getDisplayName());
        SiteActivity.makeActivity(site, (JsonElement)object);
    }

    public static void createdPage(Page page, User user) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "pageCreated");
        object.addProperty("post", page.getExternalId());
        object.add("pageName", page.getName().json());
        object.addProperty("pageSlug", page.getSlug());
        object.addProperty("user", user.getUsername());
        object.addProperty("userName", user.getProfile().getDisplayName());
        SiteActivity.makeActivity(page.getSite(), (JsonElement)object);
    }

    public static void editedPage(Page page, User user) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "pageEdited");
        object.addProperty("post", page.getExternalId());
        object.add("pageName", page.getName().json());
        object.addProperty("pageSlug", page.getSlug());
        object.addProperty("user", user.getUsername());
        object.addProperty("userName", user.getProfile().getDisplayName());
        SiteActivity.makeActivity(page.getSite(), (JsonElement)object);
    }

    public static void deletedPage(Page page, Site site, User user) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "pageDeleted");
        object.addProperty("post", (String)null);
        object.add("pageName", page.getName().json());
        object.addProperty("pageSlug", (String)null);
        object.addProperty("user", user.getUsername());
        object.addProperty("userName", user.getProfile().getDisplayName());
        SiteActivity.makeActivity(site, (JsonElement)object);
    }

    public static void recoveredPage(Page page, Site site, User user) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "pageRecovered");
        object.addProperty("post", (String)null);
        object.add("pageName", page.getName().json());
        object.addProperty("pageSlug", (String)null);
        object.addProperty("user", user.getUsername());
        object.addProperty("userName", user.getProfile().getDisplayName());
        SiteActivity.makeActivity(site, (JsonElement)object);
    }

    public void delete() {
        this.setPrevious(null);
        this.setNext(null);
        this.setSite(null);
        this.setLastActivityLineSite(null);
        this.deleteDomainObject();
    }

    public String getRender() {
        StringWriter sw = new StringWriter();
        SiteActivityRender.render(this, sw);
        return sw.toString();
    }
}

