/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu;

import java.util.EnumSet;
import org.fenixedu.bennu.core.bootstrap.AdminUserBootstrapper;
import org.fenixedu.bennu.core.bootstrap.annotations.Bootstrap;
import org.fenixedu.bennu.core.bootstrap.annotations.Bootstrapper;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.cms.domain.BlogSiteBuilder;
import org.fenixedu.cms.domain.CMSTheme;
import org.fenixedu.cms.domain.CmsSettings;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.cms.domain.RoleTemplate;
import org.fenixedu.cms.domain.SiteBuilder;

@Bootstrapper(bundle="resources.CmsResources", name="application.title.cms.bootstrapper", after={AdminUserBootstrapper.class}, sections={})
public class CmsBootstrapper {
    private static final String ADMIN_ROLE_NAME = "roles.admin";
    private static final String EDITOR_ROLE_NAME = "roles.editor";
    private static final String AUTHOR_ROLE_NAME = "roles.author";
    private static final String CONTRIBUTOR_ROLE_NAME = "roles.contributor";
    private static final String DEFAULT_BUNDLE = "CmsPermissionResources";
    private static final String SITE_BUILDER_SLUG = "defaultBuilder";

    @Bootstrap
    public static void bootstrapCms() {
        CmsSettings.init();
        if (Bennu.getInstance().getRoleTemplatesSet().isEmpty()) {
            CmsBootstrapper.initDefaultRoles();
        }
        CmsBootstrapper.createBlogSiteBuilder();
        CmsBootstrapper.createDefaultSiteBuilder();
    }

    private static void createBlogSiteBuilder() {
        BlogSiteBuilder blogBuilder = BlogSiteBuilder.getInstance();
        Bennu.getInstance().getRoleTemplatesSet().forEach(role -> blogBuilder.addRoleTemplate((RoleTemplate)((Object)role)));
        blogBuilder.setTheme(CMSTheme.getDefaultTheme());
    }

    private static void createDefaultSiteBuilder() {
        SiteBuilder builder = new SiteBuilder(SITE_BUILDER_SLUG);
        Bennu.getInstance().getRoleTemplatesSet().forEach(role -> builder.addRoleTemplate((RoleTemplate)((Object)role)));
        builder.setTheme(CMSTheme.getDefaultTheme());
    }

    public static void initDefaultRoles() {
        CmsBootstrapper.createRoleTemplate(CmsBootstrapper.getAdminPermissions(), ADMIN_ROLE_NAME);
        CmsBootstrapper.createRoleTemplate(CmsBootstrapper.getEditorPermissions(), EDITOR_ROLE_NAME);
        CmsBootstrapper.createRoleTemplate(CmsBootstrapper.getAuthorPermissions(), AUTHOR_ROLE_NAME);
        CmsBootstrapper.createRoleTemplate(CmsBootstrapper.getContributorPermissions(), CONTRIBUTOR_ROLE_NAME);
    }

    private static RoleTemplate createRoleTemplate(EnumSet<PermissionsArray.Permission> permissions, String description) {
        RoleTemplate template = new RoleTemplate();
        template.setPermissions(new PermissionsArray(permissions));
        template.setName(BundleUtil.getLocalizedString((String)DEFAULT_BUNDLE, (String)description, (String[])new String[0]));
        return template;
    }

    private static EnumSet<PermissionsArray.Permission> getEditorPermissions() {
        return EnumSet.of(PermissionsArray.Permission.CREATE_POST, new PermissionsArray.Permission[]{PermissionsArray.Permission.CREATE_PAGE, PermissionsArray.Permission.SEE_PAGES, PermissionsArray.Permission.SEE_POSTS, PermissionsArray.Permission.SEE_PRIVATE_POSTS, PermissionsArray.Permission.DELETE_OTHERS_POSTS, PermissionsArray.Permission.DELETE_PAGE, PermissionsArray.Permission.DELETE_POSTS, PermissionsArray.Permission.DELETE_PRIVATE_POSTS, PermissionsArray.Permission.DELETE_POSTS_PUBLISHED, PermissionsArray.Permission.EDIT_OTHERS_POSTS, PermissionsArray.Permission.EDIT_PAGE, PermissionsArray.Permission.EDIT_POSTS, PermissionsArray.Permission.EDIT_POSTS_PUBLISHED, PermissionsArray.Permission.LIST_CATEGORIES, PermissionsArray.Permission.EDIT_CATEGORY, PermissionsArray.Permission.DELETE_CATEGORY, PermissionsArray.Permission.CREATE_CATEGORY, PermissionsArray.Permission.PUBLISH_PAGES, PermissionsArray.Permission.PUBLISH_POSTS, PermissionsArray.Permission.LIST_MENUS, PermissionsArray.Permission.EDIT_MENU, PermissionsArray.Permission.CREATE_MENU_ITEM, PermissionsArray.Permission.DELETE_MENU_ITEM, PermissionsArray.Permission.EDIT_MENU_ITEM});
    }

    private static EnumSet<PermissionsArray.Permission> getAuthorPermissions() {
        return EnumSet.of(PermissionsArray.Permission.CREATE_POST, new PermissionsArray.Permission[]{PermissionsArray.Permission.DELETE_POSTS, PermissionsArray.Permission.DELETE_POSTS_PUBLISHED, PermissionsArray.Permission.SEE_POSTS, PermissionsArray.Permission.EDIT_POSTS, PermissionsArray.Permission.EDIT_POSTS_PUBLISHED, PermissionsArray.Permission.LIST_CATEGORIES, PermissionsArray.Permission.CREATE_CATEGORY, PermissionsArray.Permission.PUBLISH_POSTS, PermissionsArray.Permission.LIST_MENUS});
    }

    private static EnumSet<PermissionsArray.Permission> getContributorPermissions() {
        return EnumSet.of(PermissionsArray.Permission.CREATE_POST, PermissionsArray.Permission.SEE_POSTS, PermissionsArray.Permission.DELETE_POSTS, PermissionsArray.Permission.EDIT_POSTS, PermissionsArray.Permission.LIST_CATEGORIES);
    }

    private static EnumSet<PermissionsArray.Permission> getAdminPermissions() {
        return EnumSet.of(PermissionsArray.Permission.CREATE_POST, new PermissionsArray.Permission[]{PermissionsArray.Permission.CREATE_PAGE, PermissionsArray.Permission.SEE_POSTS, PermissionsArray.Permission.SEE_PRIVATE_POSTS, PermissionsArray.Permission.SEE_PAGES, PermissionsArray.Permission.SEE_PAGE_COMPONENTS, PermissionsArray.Permission.DELETE_OTHERS_POSTS, PermissionsArray.Permission.DELETE_PAGE, PermissionsArray.Permission.DELETE_POSTS, PermissionsArray.Permission.DELETE_PRIVATE_POSTS, PermissionsArray.Permission.DELETE_POSTS_PUBLISHED, PermissionsArray.Permission.EDIT_OTHERS_POSTS, PermissionsArray.Permission.EDIT_PAGE, PermissionsArray.Permission.EDIT_POSTS, PermissionsArray.Permission.EDIT_POSTS_PUBLISHED, PermissionsArray.Permission.EDIT_SITE_INFORMATION, PermissionsArray.Permission.LIST_CATEGORIES, PermissionsArray.Permission.EDIT_CATEGORY, PermissionsArray.Permission.DELETE_CATEGORY, PermissionsArray.Permission.CREATE_CATEGORY, PermissionsArray.Permission.MANAGE_ANALYTICS, PermissionsArray.Permission.MANAGE_ROLES, PermissionsArray.Permission.PUBLISH_PAGES, PermissionsArray.Permission.PUBLISH_POSTS, PermissionsArray.Permission.PUBLISH_SITE, PermissionsArray.Permission.CREATE_MENU, PermissionsArray.Permission.DELETE_MENU, PermissionsArray.Permission.LIST_MENUS, PermissionsArray.Permission.EDIT_MENU, PermissionsArray.Permission.CREATE_MENU_ITEM, PermissionsArray.Permission.DELETE_MENU_ITEM, PermissionsArray.Permission.EDIT_MENU_ITEM, PermissionsArray.Permission.CHANGE_PATH_PAGES, PermissionsArray.Permission.CHOOSE_PATH_AND_FOLDER, PermissionsArray.Permission.EDIT_SITE_INFORMATION, PermissionsArray.Permission.CHOOSE_DEFAULT_PAGE});
    }
}

