/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.ui;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import org.fenixedu.cms.domain.CMSTheme;
import org.fenixedu.cms.domain.CMSThemeFile;
import org.joda.time.DateTime;

@Path(value="/cms/assets")
public class CMSAssetsController {
    private static final String expires = DateTime.now().plusYears(1).toString("E, d MMM yyyy HH:mm:ss z");

    @Path(value="/{type}/{hash}/{path:.*}")
    @GET
    public void asset(@PathParam(value="type") String type, @PathParam(value="hash") String hash, @PathParam(value="path") String path, @Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException {
        CMSTheme theme = CMSTheme.forType(type);
        if (theme == null) {
            response.sendError(404, type);
            return;
        }
        CMSThemeFile file = theme.fileForPath("static/" + path);
        if (file == null) {
            response.sendError(404, path);
            return;
        }
        byte[] bytes = file.getContent();
        String etag = "W/\"" + bytes.length + "-" + file.getLastModified().getMillis() + "\"";
        response.setHeader("ETag", etag);
        response.setHeader("Expires", expires);
        response.setHeader("Cache-Control", "max-age=31536000");
        if (etag.equals(request.getHeader("If-None-Match"))) {
            response.setStatus(304);
        } else {
            response.setContentLength(bytes.length);
            response.setContentType(file.getContentType());
            try (ServletOutputStream stream = response.getOutputStream();){
                stream.write(bytes);
            }
            response.setStatus(200);
        }
    }
}

