/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.api.json.DateTimeViewer;
import org.fenixedu.bennu.core.api.json.LocalizedStringViewer;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.DomainObject;

@DefaultJsonAdapter(value=Category.class)
public class CategoryAdapter
implements JsonAdapter<Category> {
    public Category create(JsonElement json, JsonBuilder ctx) {
        return null;
    }

    public Category update(JsonElement json, Category category, JsonBuilder ctx) {
        PermissionEvaluation.ensureCanDoThis(category.getSite(), PermissionsArray.Permission.LIST_CATEGORIES, PermissionsArray.Permission.EDIT_CATEGORY);
        JsonObject jObj = json.getAsJsonObject();
        if (jObj.has("name") && !jObj.get("name").isJsonNull() && jObj.get("name").isJsonObject()) {
            category.setName(LocalizedString.fromJson((JsonElement)jObj.get("name")));
        }
        if (jObj.has("slug") && !jObj.get("slug").isJsonNull()) {
            category.setSlug(jObj.get("slug").getAsString());
        }
        Signal.emit((String)"fenixedu.cms.category.edited", (Object)new DomainObjectEvent((DomainObject)category));
        return category;
    }

    public JsonElement view(Category category, JsonBuilder ctx) {
        PermissionEvaluation.ensureCanDoThis(category.getSite(), PermissionsArray.Permission.LIST_CATEGORIES);
        JsonObject json = new JsonObject();
        json.addProperty("id", category.getExternalId());
        json.addProperty("slug", category.getSlug());
        json.add("creationDate", ctx.view((Object)category.getCreationDate(), DateTimeViewer.class));
        json.add("name", ctx.view((Object)category.getName(), LocalizedStringViewer.class));
        if (category.getCreatedBy() != null) {
            json.addProperty("createdBy", category.getCreatedBy().getUsername());
        }
        if (category.getSite() != null) {
            json.addProperty("site", category.getSite().getExternalId());
        }
        return json;
    }
}

